----------------------------------------------------------------
-- Q19:
--   Retrieve the item titles related by certain item with id
--   attribute value (I7).
-- Feature:
--   FOR statement
----------------------------------------------------------------
CREATE TEMPORARY TABLE related_item_TS AS (
          SELECT begin_time AS time_point FROM item
          UNION
          SELECT end_time AS time_point FROM item
          UNION
          SELECT begin_time AS time_point FROM related_item
          UNION
          SELECT end_time AS time_point FROM related_item);

CREATE VIEW related_item_CP
       AS (SELECT ts1.time_point AS begin_date,
                          ts2.time_point AS end_date
           FROM related_item_TS AS ts1, related_item_TS AS ts2
           WHERE begin_time < end_time AND
                     min_scope <= begin_time AND
                     max_scope <= end_time AND
           NOT EXISTS(SELECT time_point FROM related_item_TS
                      WHERE time_point > begin_time AND
                             time_point < end_time)
                      ORDER BY begin_time);

CREATE FUNCTION perstmt_get_related_items(item_id_in CHARACTER(10),
                                          begin_time_in DATE,
                                          end_time_in DATE)
  RETURNS ROW (title CHARACTER(100), begin_time DATE, end_time DATE) ARRAY
  READS SQL DATA
  LANGUAGE SQL
  BEGIN
    DECLARE return_tbl ROW (title CHARACTER(100),
                            begin_time DATE, end_time DATE) ARRAY;
    INSERT INTO return_tbl
       SELECT i.title,
              related_item_CP.begin_date, related_item_CP.end_date
       FROM related_item_CP ri_cp, item i, related_item ri
       WHERE i.item_id = ri.related_id AND ri.item_id = item_id_in AND
           AND i.begin_date <= ri_cp.begin_date
           AND ri_cp.end_date <= i.end_date
           AND ri.begin_date <= ri_cp.begin_date
           AND ri_cp.end_date <= ri.end_date;
    RETURN return_tbl;
  END;

SELECT * FROM perstmt_get_related_items('I7', '1900-01-01', '2099-12-31');
