----------------------------------------------------------------
-- Q11:
--   List the item titles in descending order by date of
--   release with date of release within a certain time
--   range (from 1990-01-01 to 1995-01-01).
-- Feature:
--   Temporary Table Creation

-- Slice on CREATE because of item.
----------------------------------------------------------------
CREATE FUNCTION perstmt_is_publised_in_period(item_id_in CHARACTER(10),
                                             start_date_in DATE,
                                             end_date_in DATE,
                                             begin_time_in DATE,
                                             end_time_in DATE)
  RETURNS ROW (taupsm_result BOOLEAN,
               begin_time DATE,
               end_time DATE) ARRAY
  READS SQL DATA
  LANGUAGE SQL
  BEGIN
    DECLARE return_tbl ROW (taupsm_result BOOLEAN,
                            begin_time DATE,
                            end_time DATE) ARRAY;
    CREATE TEMPORARY TABLE TS AS (
      SELECT begin_time AS time_point FROM item
      UNION
      SELECT end_time AS time_point FROM item);
    CREATE VIEW CP AS (SELECT ts1.time_point AS begin_time,
                          ts2.time_point AS end_time
                     FROM TS AS ts1, TS AS ts2
                     WHERE begin_time < end_time
                       AND NOT EXISTS(
                         SELECT time_point FROM TS
                           WHERE time_point > begin_time
                             AND time_point < end_time)
                       AND begin_time_in < ts2.time_point
                       AND ts1.time_point < end_time_in
                           ORDER BY begin_time);
    FOR temp_items AS SELECT * FROM CP
    DO
      CREATE TEMPORARY TABLE temp_item AS (
          SELECT i.item_id, i.date_of_release,
              LAST_INSTANCE(LAST_INSTANCE(i.begin_time, begin_time_in),
                            CP.begin_time) AS begin_time,
              FIRST_INSTANCE(FIRST_INSTANCE(i.end_time, end_time_in),
                             CP.end_time) AS end_time
            FROM item i, CP
            WHERE LAST_INSTANCE(LAST_INSTANCE(i.begin_time, begin_time_in),
                                CP.begin_time) <
              FIRST_INSTANCE(FIRST_INSTANCE(i.end_time, end_time_in),
                             CP.end_time);
        INSERT INTO return_tbl VALUES ( 
          (EXISTS (SELECT * FROM temp_item
                      WHERE item_id = item_id_in AND
                        date_of_release BETWEEN start_date_in AND end_date_in)),
          begin_time, end_time);
    END FOR;
    RETURN return_tbl;
  END;

SELECT i.title,
    LAST_INSTANCE(i.begin_time, t.begin_time) AS begin_time,
    FIRST_INSTANCE(i.end_time, t.end_time) AS end_time
  FROM item i, perstmt_is_published_in_period(i.item_id, '1990-01-01', 
                                              '1995-01-01',
                                              i.begin_time, i.end_time) t
  WHERE t.taupsm_result AND
    LAST_INSTANCE(i.begin_time, t.begin_time) <
        FIRST_INSTANCE(i.end_time, t.end_time);


