----------------------------------------------------------------
-- Q9:
--   Return the ISBN of an item with id attribute value (I5)
-- Feature:
--   CALL procedure from function
----------------------------------------------------------------
-- init
CREATE TABLE get_isbn_with_item_id_return_tbl (
    taupsm_result CHARACTER VARYING(20),
    begin_time DATE, end_time DATE)
-- end

-- procedure
CREATE PROCEDURE db2_ps_proc_get_isbn_with_item_id(
    IN item_id_in CHARACTER(10))
  MODIFIES SQL DATA
  LANGUAGE SQL
P1: BEGIN
  INSERT INTO get_isbn_with_item_id_return_tbl
      SELECT isbn, begin_time, end_time
        FROM item
        WHERE item_id = item_id_in;
END
-- end

-- sql
CALL db2_ps_proc_get_isbn_with_item_id(CAST('I100' AS CHARACTER(10)))
-- end

-- sql
SELECT i.isbn,
    LAST_INSTANCE(i.begin_time, t.begin_time) AS begin_time,
    FIRST_INSTANCE(i.end_time, t.end_time) AS end_time
  FROM item i, get_isbn_with_item_id_return_tbl t
--      TABLE(db2_ps_invoke_proc(CAST('I5' AS CHARACTER(10)),
--                               CAST('1900-01-01' AS DATE),
--                               CAST('2099-12-31' AS DATE))) t
  WHERE t.taupsm_result = i.isbn AND
    LAST_INSTANCE(i.begin_time, t.begin_time) <
        FIRST_INSTANCE(i.end_time, t.end_time)
-- end

