----------------------------------------------------------------
-- Q7:
--   Return item information where all its authors are from
--   certain country (Canada).
-- Feature:
--   REPEAT statement
----------------------------------------------------------------
-- init
CREATE TABLE item_id_tbl(
    item_id CHARACTER(10),
    begin_time DATE, end_time DATE)
-- end

-- init
INSERT INTO item_id_tbl SELECT DISTINCT id, begin_time, end_time FROM item
-- end

-- init
CREATE TABLE db2_ps_all_author_from_country_tbl(
    taupsm_result INT,
    item_id CHARACTER(10),
    begin_time DATE, end_time DATE)
-- end

-- init
CREATE TABLE TS (time_point DATE)
-- end

-- sql
INSERT INTO TS
  SELECT begin_time AS time_point FROM item_id_tbl
  UNION
  SELECT end_time AS time_point FROM item_id_tbl
  UNION
  SELECT begin_time AS time_point FROM item_author
  UNION
  SELECT end_time AS time_point FROM item_author
  UNION
  SELECT begin_time AS time_point FROM author
  UNION
  SELECT end_time AS time_point FROM author
-- end

-- init
CREATE TABLE while_loop_tbl (name_of_country VARCHAR(50))
-- end

-- init
CREATE VIEW CP AS
    SELECT * FROM (SELECT ts1.time_point AS begin_time,
                          ts2.time_point AS end_time
                     FROM TS AS ts1, TS AS ts2
                     WHERE ts1.time_point < ts2.time_point AND
                       $TIME_PERIOD
                       NOT EXISTS(
                         SELECT time_point FROM TS
                           WHERE time_point > ts1.time_point AND
                             time_point < ts2.time_point)
                           ORDER BY ts1.time_point) AS X
-- end

-- procedure
CREATE PROCEDURE db2_ps_proc_all_author_from_country(
    IN country VARCHAR(50),
    IN min_time DATE, IN max_time DATE)
  MODIFIES SQL DATA
  LANGUAGE SQL
P1: BEGIN
    DECLARE taupsm_result INT; 
    DECLARE var_country_name VARCHAR(50);
    DECLARE prev_begin_time DATE;
    DECLARE prev_end_time DATE;
    DECLARE prev_item_id CHARACTER(10);
    DECLARE prev_country_name VARCHAR(50);
    DECLARE temp_begin_time DATE;
    DECLARE temp_end_time DATE;
    DECLARE temp_item_id CHARACTER(10);
    DECLARE temp_country_name VARCHAR(50);
    DECLARE total_count INT;
    DECLARE first_time INT;
    DECLARE SQLCODE INTEGER DEFAULT 0;
    DECLARE country_cursor CURSOR FOR
      SELECT a.name_of_country, i.item_id,
               CP.begin_time, CP.end_time
          FROM author a, item_author ia, item_id_tbl i, CP
          WHERE a.author_id = ia.author_id AND ia.item_id = i.item_id AND
            i.begin_time <= CP.begin_time AND
            CP.begin_time <= i.end_time AND
            ia.begin_time <= CP.begin_time AND
            CP.begin_time < ia.end_time AND
            a.begin_time <= CP.begin_time AND
            CP.begin_time < a.end_time
          ORDER BY CP.begin_time, i.item_id;
    DECLARE country_sub_cursor CURSOR FOR
       SELECT name_of_country FROM while_loop_tbl;
    SET first_time = 1;
    OPEN country_cursor;
    FETCH country_cursor INTO
        temp_country_name, temp_item_id, temp_begin_time, temp_end_time;
    while1: WHILE SQLCODE = 0 DO
        IF (first_time = 1)
          THEN
            SET first_time = 0;
          ELSE
            IF (temp_begin_time <> prev_begin_time OR
                temp_item_id <> prev_item_id)
              THEN
                SET total_count = 0;
                SET taupsm_result = 1;
                OPEN country_sub_cursor;
                FETCH country_sub_cursor INTO var_country_name;
                IF SQLCODE <> 0
                  THEN SET taupsm_result = 0;
                  ELSE
                    repeat1: REPEAT
                      SET total_count = total_count + 1;
                      IF (var_country_name <> country)
                        THEN
                          SET taupsm_result = 0;
                          LEAVE repeat1;
                        ELSE
                          FETCH country_sub_cursor INTO var_country_name;
                      END IF;
                    UNTIL SQLCODE <> 0
                    END REPEAT;
                END IF;
                CLOSE country_sub_cursor;
                INSERT INTO db2_ps_all_author_from_country_tbl
                    VALUES (taupsm_result, prev_item_id,
                            prev_begin_time, prev_end_time);
                DELETE FROM while_loop_tbl;
                SET SQLCODE = 0;
            END IF;
        END IF;
        INSERT INTO while_loop_tbl VALUES (temp_country_name);
        SET prev_country_name = temp_country_name;
        SET prev_item_id = temp_item_id;
        SET prev_begin_time = temp_begin_time;
        SET prev_end_time = temp_end_time;
        FETCH country_cursor INTO
            temp_country_name, temp_item_id, temp_begin_time, temp_end_time;
    END WHILE;
    CLOSE country_cursor;
    OPEN country_sub_cursor;
    FETCH country_sub_cursor INTO var_country_name;
    SET total_count = 0;
    SET taupsm_result = 1;
    while3: WHILE SQLCODE = 0 DO
      SET total_count = total_count + 1;
      IF (var_country_name <> country)
        THEN
          SET taupsm_result = 0;
          LEAVE while3;
        ELSE
          FETCH country_sub_cursor INTO var_country_name;
      END IF;
    END WHILE;
    IF (total_count = 0 AND taupsm_result = 1)
      THEN SET taupsm_result = 0;
    END IF;
    CLOSE country_sub_cursor;
    SET SQLCODE = 0;
    INSERT INTO db2_ps_all_author_from_country_tbl
        VALUES (taupsm_result, prev_item_id,
                prev_begin_time, prev_end_time);
    DELETE FROM while_loop_tbl;
END
-- end

-- sql
CALL db2_ps_proc_all_author_from_country(CAST('Canada' AS VARCHAR(50)),
                                         $TIME_PERIOD)
-- end

-- sql
SELECT i.*,
    LAST_INSTANCE(i.begin_time, t.begin_time),
    FIRST_INSTANCE(i.end_time, t.end_time)
  FROM item i, db2_ps_all_author_from_country_tbl t
--      TABLE (db2_ps_all_author_from_country(i.id,
--                                            CAST('Canada' AS VARCHAR(50)),
--                                            i.begin_time, i.end_time)) t
  WHERE t.taupsm_result = 1 AND
    i.id = t.item_id AND
    LAST_INSTANCE(i.begin_time, t.begin_time) <
        FIRST_INSTANCE(i.end_time, t.end_time)
-- end


