----------------------------------------------------------------
-- Q3:
--   Group items released in a certain year (1990),
--   by publisher name and calculated the total number of
--   items for each group.
-- Feature:
--   RETURN with SELECT single row

-- NOTE: DB2 does not allow aggregation with a function in the
--       where clause or select (not sure which) on a correlation
--	 name not being aggregated, hence we had to play around
--	 with the correlation names in the from to get this to work.
----------------------------------------------------------------
-- init
CREATE TABLE db2_ps_get_release_date_return_tbl(
    taupsm_result DATE, item_id CHARACTER(10),
    begin_time DATE, end_time DATE)
-- end

-- procedure
CREATE PROCEDURE db2_ps_proc_get_release_date(
    IN min_time DATE, IN max_time DATE)
  MODIFIES SQL DATA
  LANGUAGE SQL
P1: BEGIN
  INSERT INTO db2_ps_get_release_date_return_tbl
      SELECT i.date_of_release AS taupsm_result, i.id,
          i.begin_time AS begin_time,
          i.end_time AS end_time 
        FROM item i
        WHERE i.begin_time $REL1 min_time AND
          i.begin_time $REL2 max_time;
END
-- end

-- sql
CALL db2_ps_proc_get_release_date($TIME_PERIOD)
-- end

-- sql
SELECT tmp.name, SUM(i.quantity_in_stock), tmp.begin_time, tmp.end_time
  FROM item i, (
    SELECT p.name AS name, ip.item_id AS item_id,
        LAST_INSTANCE(
            LAST_INSTANCE(
                LAST_INSTANCE(i.begin_time, p.begin_time),
                ip.begin_time),
            t.begin_time) AS begin_time,
        FIRST_INSTANCE(
            FIRST_INSTANCE(
                FIRST_INSTANCE(i.end_time, p.end_time),
                ip.end_time),
            t.end_time) AS end_time
      FROM item i, publisher p, item_publisher ip,
          db2_ps_get_release_date_return_tbl t
--        TABLE (db2_ps_get_release_date(
--                   i.id,
--                   LAST_INSTANCE(
--                       LAST_INSTANCE(i.begin_time, p.begin_time),
--                       ip.begin_time),
--                   FIRST_INSTANCE(
--                       FIRST_INSTANCE(i.end_time, p.end_time),
--                       ip.end_time))) t
      WHERE i.id = ip.item_id AND
        ip.publisher_id = p.publisher_id AND
        i.id = t.item_id AND
        t.taupsm_result BETWEEN '1990-01-01' AND '1991-01-01' AND
        LAST_INSTANCE(
            LAST_INSTANCE(
                LAST_INSTANCE(i.begin_time, p.begin_time),
                ip.begin_time),
            t.begin_time) <
          FIRST_INSTANCE(
              FIRST_INSTANCE(
                  FIRST_INSTANCE(i.end_time, p.end_time),
                  ip.end_time),
              t.end_time)) tmp
  WHERE i.id = tmp.item_id AND
    LAST_INSTANCE(i.begin_time, tmp.begin_time) <
        FIRST_INSTANCE(i.end_time, tmp.end_time)     
  GROUP BY tmp.name, tmp.begin_time, tmp.end_time
-- end


