----------------------------------------------------------------
-- Q19:
--   Retrieve the item titles related by certain item with id
--   attribute value (I7).
-- Feature:
--   FOR statement
----------------------------------------------------------------
-- init
CREATE TABLE db2_ps_get_related_items_return_tbl(
    taupsm_result CHARACTER(100),
    begin_time DATE, end_time DATE)
-- end

-- procedure
CREATE PROCEDURE db2_ps_proc_get_related_items(
    IN item_id_in CHARACTER(10),
    IN min_time DATE, IN max_time DATE)
  MODIFIES SQL DATA
  LANGUAGE SQL
P1: BEGIN
  INSERT INTO db2_ps_get_related_items_return_tbl
      SELECT i.title,
          LAST_INSTANCE(i.begin_time, ri.begin_time) AS begin_time,
          FIRST_INSTANCE(i.end_time, ri.end_time) AS end_time
        FROM item i, related_item ri
        WHERE i.id = ri.related_id AND ri.item_id = item_id_in AND
          LAST_INSTANCE(i.begin_time, ri.begin_time) <
            FIRST_INSTANCE(i.end_time, ri.end_time) AND
          LAST_INSTANCE(i.begin_time, ri.begin_time) $REL1 min_time AND
          LAST_INSTANCE(i.begin_time, ri.begin_time) $REL2 max_time;
END
-- end

-- sql
CALL db2_ps_proc_get_related_items(
    CAST('I100' AS CHARACTER(10)),
    $TIME_PERIOD)
-- end

-- sql
SELECT taupsm_result, begin_time, end_time
  FROM db2_ps_get_related_items_return_tbl
-- end

