----------------------------------------------------------------
-- Q14:
--   Return the names of publishers who publish books between
--   a period of time from 1990-01-01 to 1991-01-01 but
--   do not have FAX number.
-- Feature:
--   Local cursor declaration
--   FETCH, OPEN, and CLOSE statements
----------------------------------------------------------------
-- init
CREATE TABLE db2_ps_is_released_in_period_return_tbl(
    publisher_id CHARACTER(10),
    begin_time DATE, end_time DATE)
-- end

-- init
CREATE TABLE all_publisher_id_tbl(
    publisher_id CHARACTER(10),
    begin_time DATE,
    end_time DATE)
-- end

-- procedure
CREATE PROCEDURE db2_ps_proc_is_released_in_period(
    IN start_date, IN end_date)
  MODIFIES SQL DATA
  LANGUAGE SQL
P1: BEGIN
    DECLARE var_publisher_id CHARACTER(10);
    DECLARE var_begin_time DATE;
    DECLARE var_end_time DATE;
    DECLARE SQLCODE INTEGER DEFAULT 0;
    DECLARE publisher_cursor CURSOR FOR
        SELECT api.publisher_id AS publisher_id,
            LAST_INSTANCE(
                LAST_INSTANCE(i.begin_time, ip.begin_time),
                api.begin_time) AS begin_time,
            FIRST_INSTANCE(
                FIRST_INSTANCE(i.end_time, ip.end_time),
                api.end_time) AS end_time
          FROM item i, item_publisher ip, all_publisher_id_tbl api
          WHERE i.id = ip.item_id AND
              ip.publisher_id = api.publisher_id AND
              i.date_of_release BETWEEN start_date AND end_date AND
              LAST_INSTANCE(
                  LAST_INSTANCE(i.begin_time, ip.begin_time),
                  api.begin_time) <
                FIRST_INSTANCE(
                    FIRST_INSTANCE(i.end_time, ip.end_time),
                    api.end_time) AND
              LAST_INSTANCE(
                  LAST_INSTANCE(i.begin_time, ip.begin_time),
                  api.begin_time) <= min_time AND
              min_time < FIRST_INSTANCE(
                             FIRST_INSTANCE(i.end_time, ip.end_time),
                             api.end_time);
    OPEN publisher_cursor;
    FETCH publisher_cursor INTO var_publisher_id, var_begin_time, var_end_time;
    WHILE SQLCODE = 0 DO
      INSERT INTO db2_ps_is_released_in_period_return_tbl
          VALUES(var_publisher_id, var_begin_time, var_end_time);
      FETCH publisher_cursor INTO
          var_publisher_id, var_begin_time, var_end_time;
    END WHILE;
    CLOSE publisher_cursor;
END
-- end

-- sql
INSERT INTO all_publisher_id_tbl
    SELECT DISTINCT publisher_id, begin_time, end_time
      FROM publisher
-- end

-- sql
CALL db2_ps_proc_is_released_in_period(CAST('1990-01-01' AS DATE),
                                       CAST('1991-01-01' AS DATE))
-- end

-- sql
SELECT p.name,
    LAST_INSTANCE(p.begin_time, t.begin_time),
    FIRST_INSTANCE(p.end_time, t.end_time)
  FROM publisher p,
    db2_ps_is_released_in_period_return_tbl t
  WHERE p.fax_number IS NULL AND
    p.publisher_id = t.publisher_id AND
    LAST_INSTANCE(p.begin_time, t.begin_time) <
        FIRST_INSTANCE(p.end_time, t.end_time)
-- end


