----------------------------------------------------------------
-- Q11:
--   List the item titles in descending order by date of
--   release with date of release within a certain time
--   range (from 1990-01-01 to 1995-01-01).
-- Feature:
--   Temporary Table Creation

--NOTE: optimization 6 can be done only AFTER the DB2 mapping, and
--    so this wouldn't be possible in our current framework
-- NOTE: This optimization also exploits the fact that the item_id
--    that is being used in the original EXISTS is the primary key,
--    and so there will not be any overlapping tuples.
----------------------------------------------------------------
-- init
CREATE TABLE db2_ps_is_published_in_period_return_tbl(
    -- taupsm_result INT, -- don't need this because of optimization 3
    item_id CHARACTER(10), begin_time DATE, end_time DATE)
-- end

-- init
CREATE TABLE item_id_tbl (item_id CHARACTER(10),
                          begin_time DATE, end_time DATE)
-- end

-- procedure
CREATE PROCEDURE db2_ps_proc_is_published_in_period()
  MODIFIES SQL DATA
  LANGUAGE SQL
P1: BEGIN
  DECLARE GLOBAL TEMPORARY TABLE temp_item AS (
        SELECT i.id, i.date_of_release, i.begin_time, i.end_time
          FROM item i) DEFINITION ONLY;
  P2: BEGIN
    INSERT INTO session.temp_item
        SELECT i.id, i.date_of_release,
            i.begin_time AS begin_time,
            i.end_time AS end_time
          FROM item i;
-- don't need to do slice because of optimization 6
    FOR item_id_cur AS
        SELECT item_id, begin_time, end_time FROM item_id_tbl
      DO
        IF (EXISTS (SELECT ti.* FROM session.temp_item ti
                      WHERE ti.id = item_id_cur.item_id AND
                        ti.date_of_release BETWEEN
                            '1990-01-01' AND '1995-01-01' AND
                        ti.begin_time = item_id_cur.begin_time AND
                        ti.end_time = item_id_cur.end_time))
        THEN INSERT INTO db2_ps_is_published_in_period_return_tbl VALUES (
            -- 1, -- don't need this because of optimization 3 
            item_id_cur.item_id,
            item_id_cur.begin_time, item_id_cur.end_time);
-- don't need to insert false because of optimization 2
--        ELSE INSERT INTO db2_ps_is_published_in_period_return_tbl VALUES (
--            0, item_id_cur.item_id,
--            item_id_cur.begin_time, item_id_cur.end_time);
        END IF;
    END FOR;
    DROP TABLE session.temp_item;
  END P2;
END P1
-- end

-- sql
INSERT INTO item_id_tbl SELECT DISTINCT id, begin_time, end_time FROM item
-- end

-- sql
CALL db2_ps_proc_is_published_in_period()
-- end

-- sql
SELECT i.title,
    LAST_INSTANCE(i.begin_time, t.begin_time),
    FIRST_INSTANCE(i.end_time, t.end_time)
  FROM item i, db2_ps_is_published_in_period_return_tbl t
  WHERE --t.taupsm_result = 1 AND -- don't need this because of optimization 3
    i.id = t.item_id AND
    LAST_INSTANCE(i.begin_time, t.begin_time) <
        FIRST_INSTANCE(i.end_time, t.end_time)
-- end

-- clean
DROP TABLE item_id_tbl
-- end

-- clean
DROP PROCEDURE db2_ps_proc_is_published_in_period
-- end

-- clean
DROP TABLE db2_ps_is_published_in_period_return_tbl
-- end
