----------------------------------------------------------------
-- Q8:
--   Return the publisher of an item with id attribute
--   value (I4).
-- Feature:
--   Loop name with FOR statement
----------------------------------------------------------------
CREATE TEMPORARY TABLE TS AS (
  SELECT begin_time AS time_point FROM item
  UNION
  SELECT end_time AS time_point FROM item
  UNION
  SELECT begin_time AS time_point FROM publisher
  UNION
  SELECT end_time AS time_point FROM publisher
  UNION
  SELECT begin_time AS time_point FROM item_publisher
  UNION
  SELECT end_time AS time_point FROM item_publisher);

CREATE VIEW CP AS (SELECT ts1.time_point AS begin_time,
                          ts2.time_point AS end_time
                     FROM TS AS ts1, TS AS ts2
                     WHERE begin_time < end_time AND
                       NOT EXISTS(
                         SELECT time_point FROM TS
                           WHERE time_point > begin_time AND
                             time_point < end_time)
                           ORDER BY begin_time);

CREATE FUNCTION maxmap_get_publisher_id_by_item_id(item_id CHARACTER(10),
                                                   begin_time DATE,
                                                   end_time DATE)
  RETURNS CHARACTER(10)
  READS SQL DATA
  LANGUAGE SQL
  BEGIN
    FOR related AS
      SELECT i.id, ip.publisher_id FROM item i, item_publisher ip
        WHERE i.id = ip.item_id AND
          i.begin_time <= begin_time_in AND
          begin_time_in < i.end_time AND
          ip.begin_time <= begin_time_in AND
          begin_time_in < ip.end_time
    DO
      IF related.id = item_id
      THEN
        RETURN related.publisher_id;
      END IF;
    END FOR;
  END;

SELECT p.*, CP.begin_time, CP.end_time
  FROM publisher p, CP
  WHERE p.publisher_id = maxmap_get_publisher_id_by_item_id(
      'I4', CP.begin_time, CP.end_time) AND
    p.begin_time <= CP.begin_time AND
    CP.begin_time < p.end_time;

