----------------------------------------------------------------
-- Q7c:
--   Return item information where all its authors are from
--   certain country (Canada).
-- Feature:
--   nested FETCHes
----------------------------------------------------------------
CREATE TEMPORARY TABLE TS AS (
  SELECT begin_time AS time_point FROM item
  UNION
  SELECT end_time AS time_point FROM item
  UNION
  SELECT begin_time AS time_point FROM author
  UNION
  SELECT end_time AS time_point FROM author
  UNION
  SELECT begin_time AS time_point FROM item_author
  UNION
  SELECT end_time AS time_point FROM item_author);

CREATE VIEW CP AS (SELECT ts1.time_point AS begin_time,
                          ts2.time_point AS end_time
                     FROM TS AS ts1, TS AS ts2
                     WHERE begin_time < end_time AND
                       NOT EXISTS(
                         SELECT time_point FROM TS
                           WHERE time_point > begin_time AND
                             time_point < end_time)
                           ORDER BY begin_time);

CREATE FUNCTION maxmap_all_author_from_country_b(item_id_in CHARACTER(10),
                                                 country_in CHARACTER(20),
                                                 begin_time_in DATE,
                                                 end_time_in DATE)
  RETURNS BOOLEAN
  READS SQL DATA
  LANGUAGE SQL
  BEGIN
    DECLARE country_name CHARACTER(20);
    DECLARE begin_time_var1 DATE;
    DECLARE end_time_var1 DATE;
    DECLARE begin_time_var2 DATE;
    DECLARE end_time_var2 DATE;
    DECLARE author_id_var2 CHARACTER(10);
    DECLARE item_id_var2 CHARACTER(10);
    DECLARE country_cursor CURSOR FOR
        SELECT name_of_country, begin_time, end_time
          FROM author
          WHERE begin_time <= begin_time_in AND
            begin_time_in < end_time;
    DECLARE author_not_found BOOLEAN;
    DECLARE not_found CONDITION FOR SQLSTATE '02000';
    OPEN author_cursor;
    FETCH author_cursor INTO country_name_var, author_id_var,
        begin_time_var1, end_time_var1;
    SET author_not_found = not_found;
    DECLARE item_author_cursor CURSOR FOR
        SELECT author_id, item_id, begin_time, end_time
          FROM item_author
          WHERE author_id = author_id_var AND 
            begin_time <= begin_time_in AND
            begin_time_in < end_time AND
            item_id = item_id_in;
    DECLARE item_author_not_found BOOLEAN;
    REPEAT
      FETCH item_author_cursor INTO author_id_var2, item_id_var2,
          begin_time_var2, end_time_var2;
      SET item_author_not_found = not_found;
      IF (country_name_var <> country_in AND (NOT item_author_not_found))
      THEN
        BEGIN
          CLOSE author_cursor;
          CLOSE item_author_cursor;
          RETURN FALSE;
        END;
      ELSE
        BEGIN
          FETCH author_cursor INTO country_name_var, author_id_var,
              begin_time_var1, end_time_var1;
          SET author_not_found = not_found;
      END IF;
      UNTIL item_author_not_found;
    END REPEAT;
    CLOSE author_cursor;
    CLOSE item_author_cursor;
    RETURN TRUE;
  END;

SELECT i.*, CP.begin_time, CP.end_time
  FROM item i, CP
  WHERE maxmap_all_author_from_country_b(i.item_id, 'Canada',
                                         CP.begin_time, CP.end_time) AND
      i.begin_time <= CP.begin_time AND
      CP.begin_time < i.end_time;

