----------------------------------------------------------------
-- Q7b:
--   Return item information where all its authors are from
--   certain country (Canada).
-- Feature:
--   REPEAT statement
----------------------------------------------------------------
CREATE TEMPORARY TABLE TS AS (
  SELECT begin_time AS time_point FROM item
  UNION
  SELECT end_time AS time_point FROM item
  UNION
  SELECT begin_time AS time_point FROM author
  UNION
  SELECT end_time AS time_point FROM author
  UNION
  SELECT begin_time AS time_point FROM item_author
  UNION
  SELECT end_time AS time_point FROM item_author);

CREATE VIEW CP AS (SELECT ts1.time_point AS begin_time,
                          ts2.time_point AS end_time
                     FROM TS AS ts1, TS AS ts2
                     WHERE begin_time < end_time AND
                       NOT EXISTS(
                         SELECT time_point FROM TS
                           WHERE time_point > begin_time AND
                             time_point < end_time)
                           ORDER BY begin_time);

CREATE FUNCTION maxmap_all_author_from_country_b(bid CHARACTER(10),
                                                 country CHARACTER(20),
                                                 begin_time DATE,
                                                 end_time DATE)
  RETURNS BOOLEAN
  READS SQL DATA
  LANGUAGE SQL
  BEGIN
    DECLARE country_name CHARACTER(20);
    DECLARE country_cursor CURSOR FOR
        SELECT a.name_of_country
          FROM author a, item_author ia
          WHERE a.author_id = ia.author_id AND 
            a.begin_time <= begin_time_in AND
            begin_time_in < a.end_time AND
            ia.begin_time <= begin_time_in AND
            begin_time_in < ia.end_time AND
            ia.item_id = bid;
    DECLARE country_not_found CONDITION FOR SQLSTATE '02000';
    OPEN country_cursor;
    FETCH country_cursor INTO country_name;
    REPEAT
      IF (country_name <> country)
      THEN
        BEGIN
          close country_cursor;
          RETURN FALSE;
        END;
      ELSE FETCH country_cursor INTO country_name;
      END IF;
      UNTIL country_not_found;
    END REPEAT;
    CLOSE country_cursor;
    RETURN TRUE;
  END;

SELECT i.*, CP.begin_time, CP.end_time
  FROM item i, CP
  WHERE maxmap_all_author_from_country_b(i.id, 'Canada',
                                         CP.begin_time, CP.end_time) AND
      i.begin_time <= CP.begin_time AND
      CP.begin_time < i.end_time;

