----------------------------------------------------------------
-- Q2b:
--   Find the title of the item which has matching author
--   first name (Ben).
-- Feature:
--   Multiple SET statements
----------------------------------------------------------------
CREATE TEMPORARY TABLE TS AS (
  SELECT begin_time AS time_point FROM item
  UNION
  SELECT end_time AS time_point FROM item
  UNION
  SELECT begin_time AS time_point FROM item_author
  UNION
  SELECT end_time AS time_point FROM item_author);

CREATE VIEW CP AS (SELECT ts1.time_point AS begin_time,
                          ts2.time_point AS end_time
                     FROM TS AS ts1, TS AS ts2
                     WHERE begin_time < end_time AND
                       NOT EXISTS(
                         SELECT time_point FROM TS
                           WHERE time_point > begin_time AND
                             time_point < end_time)
                           ORDER BY begin_time);

CREATE FUNCTION maxmap_get_author_name_b(aid CHARACTER(10),
                                         begin_time DATE, end_time DATE)
  RETURNS CHARACTER(50)
  READS SQL DATA
  LANGUAGE SQL
  BEGIN
    DECLARE fname CHARACTER(50);
    SET fname = 'Bob';
    SET fname = (SELECT a.first_name FROM author a
                   WHERE a.author_id = aid AND
                     a.begin_time <= begin_time AND
                     begin_time < a.end_time);
    RETURN fname;
  END;

SELECT i.title, CP.begin_time, CP.end_time
  FROM item i, item_author ia, CP
  WHERE i.id = ia.item_id AND
    maxmap_get_author_name_b(ia.author_id,
                             CP.begin_time, CP.end_time) = 'Benn' AND
    i.begin_time <= CP.begin_time AND
    CP.begin_time < i.end_time AND
    ia.begin_time <= CP.begin_time AND
    CP.begin_time < ia.end_time;

