-----------------------------------------------------------------
-- Q10:
--   List the item titles ordered alphabetically by publisher
--   name, with release date within a certain time period
--   (from 1990-01-01 to 1995-01-01)
-- Feature:
--   IF without CURSOR
-----------------------------------------------------------------
CREATE TEMPORARY TABLE TS AS (
  SELECT begin_time AS time_point FROM item
  UNION
  SELECT end_time AS time_point FROM item
  UNION
  SELECT begin_time AS time_point FROM publisher
  UNION
  SELECT end_time AS time_point FROM publisher
  UNION
  SELECT begin_time AS time_point FROM item_publisher
  UNION
  SELECT end_time AS time_point FROM item_publisher);

CREATE VIEW CP AS (SELECT ts1.time_point AS begin_time,
                          ts2.time_point AS end_time
                     FROM TS AS ts1, TS AS ts2
                     WHERE begin_time < end_time AND
                       NOT EXISTS(
                         SELECT time_point FROM TS
                           WHERE time_point > begin_time AND
                             time_point < end_time)
                           ORDER BY begin_time);

CREATE FUNCTION maxmap_item_of_90s(in_item_id CHARACTER (10),
                                     begin_time_in DATE)
  RETURNS BOOLEAN
  READS SQL DATA
  LANGUAGE SQL
  BEGIN
    DECLARE rd DATE;
    SET rd =
     (SELECT date_of_release
        FROM item
	WHERE id = in_item_id AND
        begin_time <= begin_time_in AND
        begin_time_in <= end_time);
    IF (rd >= '1990-01-01') AND (rd < '1995-01-01')
    THEN RETURN TRUE;
    ELSE RETURN FALSE;
    END IF;
  END;

SELECT i.title, p.name, CP.begin_time, CP.end_time
  FROM publisher p, item i, item_publisher ip, CP
  WHERE i.id = ip.item_id AND
    ip.publisher_id = p.publisher_id AND
    maxmap_item_of_90s(i.date_of_release) AND
    p.begin_time <= CP.begin_time AND
    CP.begin_time < p.end_time AND
    i.begin_time <= CP.begin_time AND
    CP.begin_time < i.end_time
  ORDER BY p.name;

