----------------------------------------------------------------
-- Q9:
--   Return the ISBN of an item with id attribute value (I5)
-- Feature:
--   CALL procedure from function
----------------------------------------------------------------
-- init
CREATE TABLE TS (time_point DATE)
-- end

-- sql
INSERT INTO TS
  SELECT begin_time AS time_point FROM item
  UNION
  SELECT end_time AS time_point FROM item
-- end

-- init
CREATE VIEW CP AS
    SELECT * FROM (SELECT ts1.time_point AS begin_time,
                          ts2.time_point AS end_time
                     FROM TS AS ts1, TS AS ts2
                     WHERE ts1.time_point < ts2.time_point AND
                       $TIME_PERIOD
                       NOT EXISTS(
                         SELECT time_point FROM TS
                           WHERE time_point > ts1.time_point AND
                             time_point < ts2.time_point)
                           ORDER BY ts1.time_point) AS X
-- end

-- procedure
CREATE PROCEDURE db2_max_proc_get_isbn_with_item_id(
    IN item_id_in CHARACTER(10),
    IN begin_time_in DATE,
    OUT isbn_out CHARACTER VARYING(20))
  READS SQL DATA
  LANGUAGE SQL
P1: BEGIN
  SET isbn_out =
      (SELECT i.isbn
         FROM item i
         WHERE i.id = item_id_in AND
             i.begin_time <= begin_time_in AND
             begin_time_in < i.end_time);
END
-- end

-- function
CREATE FUNCTION db2_max_invoke_proc(item_id_in CHARACTER(10),
                                    begin_time_in DATE)
  RETURNS CHARACTER VARYING(20)
  READS SQL DATA
  LANGUAGE SQL
F1: BEGIN ATOMIC
  DECLARE taupsm_result CHARACTER VARYING(20);
  CALL db2_max_proc_get_isbn_with_item_id(
        item_id_in, begin_time_in, taupsm_result);
  RETURN taupsm_result;
END
-- end

-- sql
SELECT i.isbn, CP.begin_time, CP.end_time
  FROM item i, CP
  WHERE i.isbn = db2_max_invoke_proc(CAST('I100' AS CHARACTER(10)),
                                     CP.begin_time) AND
      i.begin_time <= CP.begin_time AND
      CP.begin_time < i.end_time
-- end


