----------------------------------------------------------------
-- Q5: 
--   List the last name of the authors with a matching id of
--   value (I3).
-- Feature:
--   Function in the SELECT statement
----------------------------------------------------------------
-- init
CREATE TABLE TS (time_point DATE)
-- end

-- sql
INSERT INTO TS
  SELECT begin_time AS time_point FROM item
  UNION
  SELECT end_time AS time_point FROM item
  UNION
  SELECT begin_time AS time_point FROM author
  UNION
  SELECT end_time AS time_point FROM author
  UNION
  SELECT begin_time AS time_point FROM item_author
  UNION
  SELECT end_time AS time_point FROM item_author
-- end

-- init
CREATE VIEW CP AS
    SELECT * FROM (SELECT ts1.time_point AS begin_time,
                          ts2.time_point AS end_time
                     FROM TS AS ts1, TS AS ts2
                     WHERE ts1.time_point < ts2.time_point AND
                       $TIME_PERIOD
                       NOT EXISTS(
                         SELECT time_point FROM TS
                           WHERE time_point > ts1.time_point AND
                             time_point < ts2.time_point)
                           ORDER BY ts1.time_point) AS X
-- end

-- function
CREATE FUNCTION db2_max_get_author_name(author_id_in CHARACTER(10),
                                        begin_time_in DATE)
  RETURNS CHARACTER(50)
  READS SQL DATA
  LANGUAGE SQL
F1: BEGIN ATOMIC
  DECLARE taupsm_result CHARACTER(50);
  SET taupsm_result =
      (SELECT a.last_name
         FROM author a
         WHERE author_id_in = a.author_id AND
             a.begin_time <= begin_time_in AND
             begin_time_in < a.end_time);
  RETURN taupsm_result;
END
-- end

-- sql
SELECT db2_max_get_author_name(ia.author_id,
                               CP.begin_time),
    CP.begin_time, CP.end_time
  FROM item i, item_author ia, CP
  WHERE i.id = 'I100' AND
      i.id = ia.item_id AND
      i.begin_time <= CP.begin_time AND
      CP.begin_time < i.end_time AND
      ia.begin_time <= CP.begin_time AND
      CP.begin_time < ia.end_time
-- end


