----------------------------------------------------------------
-- Q3:
--   Group items released in a certain year (1990),
--   by publisher name and calculated the total number of
--   items for each group.
-- Feature:
--   RETURN with SELECT single row
-- Note
--   For DB2, an error occurs when a function is invoked in
--   conjunct with BETWEEN...AND statement.
--   The error code will be -583.
--   Executing "? sqlN583" will show the explanation.
--   The explained solution is:
--     *  Instead of the BETWEEN predicate, use the corresponding statement
--     using the equivalent combination of comparison predicates (a>=b and
--     a<=c instead of a between b and c).

----------------------------------------------------------------
-- init
CREATE TABLE TS (time_point DATE)
-- end

-- sql
INSERT INTO TS
  SELECT begin_time AS time_point FROM item
  UNION
  SELECT end_time AS time_point FROM item
  UNION
  SELECT begin_time AS time_point FROM publisher
  UNION
  SELECT end_time AS time_point FROM publisher
  UNION
  SELECT begin_time AS time_point FROM item_publisher
  UNION
  SELECT end_time AS time_point FROM item_publisher
-- end

-- init
CREATE VIEW CP AS
    SELECT * FROM (SELECT ts1.time_point AS begin_time,
                          ts2.time_point AS end_time
                     FROM TS AS ts1, TS AS ts2
                     WHERE ts1.time_point < ts2.time_point AND
                       $TIME_PERIOD
                       NOT EXISTS(
                         SELECT time_point FROM TS
                           WHERE time_point > ts1.time_point AND
                             time_point < ts2.time_point)
                           ORDER BY ts1.time_point) AS X
-- end

-- function
CREATE FUNCTION db2_max_get_release_date(item_id CHARACTER(10),
                                         begin_time_in DATE)
  RETURNS DATE
  READS SQL DATA
  LANGUAGE SQL
F1: BEGIN ATOMIC
    RETURN (SELECT i.date_of_release FROM item i
              WHERE i.id = item_id AND
              i.begin_time <= begin_time_in AND
              begin_time_in < i.end_time);
END
-- end

-- sql
SELECT p.name, SUM(i.quantity_in_stock), CP.begin_time, CP.end_time
  FROM item i, publisher p, item_publisher ip, CP
  WHERE i.id = ip.item_id AND
    ip.publisher_id = p.publisher_id AND
    db2_max_get_release_date(i.id, CP.begin_time) >=
        '1990-01-01' AND
    db2_max_get_release_date(i.id, CP.begin_time) <=
        '1991-01-01' AND
    p.begin_time <= CP.begin_time AND
    CP.begin_time < p.end_time AND
    i.begin_time <= CP.begin_time AND
    CP.begin_time < i.end_time AND
    ip.begin_time <= CP.begin_time AND
    CP.begin_time < ip.end_time 
  GROUP BY p.name, CP.begin_time, CP.end_time
-- end


