----------------------------------------------------------------
-- Q20:
--   Retrieve the item title whose size (length*width*height)
--   is bigger than certain number (500000).
-- Feature:
--   ASSIGNMENT statement
----------------------------------------------------------------
-- init
CREATE TABLE TS (time_point DATE)
-- end

-- sql
INSERT INTO TS
  SELECT begin_time AS time_point FROM item
  UNION
  SELECT end_time AS time_point FROM item
-- end

-- init
CREATE VIEW CP AS
    SELECT * FROM (SELECT ts1.time_point AS begin_time,
                          ts2.time_point AS end_time
                     FROM TS AS ts1, TS AS ts2
                     WHERE ts1.time_point < ts2.time_point AND
                       $TIME_PERIOD
                       NOT EXISTS(
                         SELECT time_point FROM TS
                           WHERE time_point > ts1.time_point AND
                             time_point < ts2.time_point)
                           ORDER BY ts1.time_point) AS X
-- end

-- function
CREATE FUNCTION db2_max_sizeof_item(in_item_id CHARACTER(10))
  RETURNS DOUBLE
  READS SQL DATA
  LANGUAGE SQL
F1: BEGIN ATOMIC
    DECLARE length DOUBLE;
    DECLARE width DOUBLE;
    DECLARE height DOUBLE;
    DECLARE size DOUBLE;
    SET length = 
      (SELECT length
         FROM item
         WHERE id = in_item_id AND
         begin_time <= begin_time_in AND
         begin_time_in < end_time);
    SET width = 
      (SELECT width
         FROM item
         WHERE id = in_item_id AND
         begin_time <= begin_time_in AND
         begin_time_in < end_time);
    SET height = 
      (SELECT height
         FROM item
         WHERE id = in_item_id AND
         begin_time <= begin_time_in AND
         begin_time_in < end_time);
    SET size = length * width * height;
    RETURN size;
END
-- end

-- sql
SELECT i.title, CP.begin_time, CP.end_time
  FROM item i, CP
  WHERE db2_max_sizeof_item(i.id) > 500000 AND
    i.begin_time <= CP.begin_time AND
    CP.begin_time < i.end_time
-- end



