----------------------------------------------------------------
-- Q19:
--   Retrieve the item titles related by certain item with id
--   attribute value (I7).
-- Feature:
--   Call function in the FROM statement
----------------------------------------------------------------
-- init
CREATE TABLE TS (time_point DATE)
-- end

-- sql
INSERT INTO TS
  SELECT begin_time AS time_point FROM item
  UNION
  SELECT end_time AS time_point FROM item
  UNION
  SELECT begin_time AS time_point FROM related_item
  UNION
  SELECT end_time AS time_point FROM related_item
-- end

-- init
CREATE VIEW CP AS
    SELECT * FROM (SELECT ts1.time_point AS begin_time,
                          ts2.time_point AS end_time
                     FROM TS AS ts1, TS AS ts2
                     WHERE ts1.time_point < ts2.time_point AND
                       $TIME_PERIOD
                       NOT EXISTS(
                         SELECT time_point FROM TS
                           WHERE time_point > ts1.time_point AND
                             time_point < ts2.time_point)
                           ORDER BY ts1.time_point) AS X
-- end

-- init
CREATE TABLE db2_max_get_related_items_return_tbl (title CHARACTER(100),
                                                   begin_time DATE,
                                                   end_time DATE)
-- end

-- function
CREATE FUNCTION db2_max_get_related_items(bid CHARACTER(10),
                                          begin_time_in DATE,
                                          end_time_in DATE)
  RETURNS TABLE (title CHARACTER(100), begin_time DATE, end_time DATE)
  MODIFIES SQL DATA
  LANGUAGE SQL
F1: BEGIN ATOMIC
    INSERT INTO db2_max_get_related_items_return_tbl
      SELECT i.title, begin_time_in, end_time_in
        FROM item i, related_item ri
        WHERE i.id = ri.related_id AND ri.item_id = bid AND
          i.begin_time <= begin_time_in AND
          begin_time_in < i.end_time AND
          ri.begin_time <= begin_time_in AND
          begin_time_in < ri.end_time;
    RETURN (SELECT * FROM db2_max_get_related_items_return_tbl);
END
-- end

-- sql
SELECT t.title, CP.begin_time, CP.end_time
  FROM CP, TABLE(db2_max_get_related_items(CAST('I100' AS CHARACTER(10)),
                                           CP.begin_time, CP.end_time)) t
  WHERE t.begin_time <= CP.begin_time AND
    CP.begin_time < t.end_time
-- end



