----------------------------------------------------------------
-- Q17:
--   Return the first id of the items whose descriptions contain
--   a certain word ("hockey").
-- Feature:
--   LEAVE statement
----------------------------------------------------------------
-- init
CREATE TABLE TS (time_point DATE)
-- end

-- sql
INSERT INTO TS
  SELECT begin_time AS time_point FROM item
  UNION
  SELECT end_time AS time_point FROM item
-- end

-- init
CREATE VIEW CP AS
    SELECT * FROM (SELECT ts1.time_point AS begin_time,
                          ts2.time_point AS end_time
                     FROM TS AS ts1, TS AS ts2
                     WHERE ts1.time_point < ts2.time_point AND
                       $TIME_PERIOD
                       NOT EXISTS(
                         SELECT time_point FROM TS
                           WHERE time_point > ts1.time_point AND
                             time_point < ts2.time_point)
                           ORDER BY ts1.time_point) AS X
-- end

-- function
CREATE FUNCTION db2_max_get_first_item_about_hockey(begin_time_in DATE)
  RETURNS CHARACTER(10)
  READS SQL DATA
  LANGUAGE SQL
F1: BEGIN ATOMIC
    DECLARE return_id CHARACTER(10);
    SET return_id = '';
    for_loop: FOR all_items AS
      SELECT i.id AS item_id FROM item i
        WHERE i.description LIKE '%hockey%' AND
            i.begin_time <= begin_time_in AND
            begin_time_in < i.end_time
    DO
      SET return_id = all_items.item_id;
      LEAVE for_loop;
    END FOR;
    RETURN return_id;
END
-- end

-- sql
SELECT i.id, CP.begin_time, CP.end_time
  FROM item i, CP
  WHERE i.id = db2_max_get_first_item_about_hockey(CP.begin_time) AND
      i.begin_time <= CP.begin_time AND
      CP.begin_time < i.end_time
-- end


