----------------------------------------------------------------
-- Q11:
--   List the item titles in descending order by date of
--   release with date of release within a certain time
--   range (from 1990-01-01 to 1995-01-01).
-- Feature:
--   Temporary Table Creation
-- Caution:
--   Due to the following reasons specific to DB2,
--   a per-stmt like procudure is used.
--   1. to use temporary table, procedure must be used
--   2. MODIFIES SQL DATA must be specified on the procedure
--   3. a function calling this procecure must specify
--      MODIFIES SQL DATA as well
--   4. this function then must RETURN TABLE() (a DB2 rule)
--   5. this function then must be called from FROM clause
--   6. calling function from FROM clause simply won't work
--   7. therefore, a table must be created to store
--      intermediate results
----------------------------------------------------------------
-- init
CREATE TABLE TS (time_point DATE)
-- end

-- sql
INSERT INTO TS 
  SELECT begin_time AS time_point FROM item
  UNION
  SELECT end_time AS time_point FROM item
-- end

-- init
CREATE VIEW CP AS 
    SELECT * FROM (SELECT ts1.time_point AS begin_time,
                          ts2.time_point AS end_time
                     FROM TS AS ts1, TS AS ts2
                     WHERE ts1.time_point < ts2.time_point AND
                       $TIME_PERIOD
                       NOT EXISTS(
                         SELECT time_point FROM TS
                           WHERE time_point > ts1.time_point AND
                             time_point < ts2.time_point)
                           ORDER BY ts1.time_point) AS X
-- end

-- init
CREATE TABLE db2_max_is_published_in_period_return_tbl(
    taupsm_result INT, item_id CHARACTER(10), begin_time DATE, end_time DATE)
-- end

-- init
CREATE TABLE item_id_tbl (item_id CHARACTER(10),
                          begin_time DATE, end_time DATE)
-- end

-- procedure
CREATE PROCEDURE db2_max_proc_is_published_in_period(IN start_date_in DATE,
                                                     IN end_date_in DATE)
  MODIFIES SQL DATA
  LANGUAGE SQL
P1: BEGIN
  DECLARE GLOBAL TEMPORARY TABLE temp_item AS (
        SELECT i.id, i.date_of_release, i.begin_time, i.end_time
          FROM item i) DEFINITION ONLY;
  P2: BEGIN
    INSERT INTO session.temp_item
        SELECT i.id, i.date_of_release,
            i.begin_time AS begin_time,
            i.end_time AS end_time
          FROM item i;
    FOR item_id_cur AS
        SELECT item_id, begin_time, end_time FROM item_id_tbl
      DO
        IF (EXISTS (SELECT ti.* FROM session.temp_item ti
                      WHERE ti.id = item_id_cur.item_id AND
                        ti.date_of_release BETWEEN
                            start_date_in AND end_date_in AND
                        ti.begin_time = item_id_cur.begin_time AND
                        ti.end_time = item_id_cur.end_time))
        THEN INSERT INTO db2_max_is_published_in_period_return_tbl VALUES (
            1, item_id_cur.item_id,
            item_id_cur.begin_time, item_id_cur.end_time);
        ELSE INSERT INTO db2_max_is_published_in_period_return_tbl VALUES (
            0, item_id_cur.item_id,
            item_id_cur.begin_time, item_id_cur.end_time);
        END IF;
    END FOR;
    DROP TABLE session.temp_item;
  END P2;
END P1
-- end

-- function
CREATE FUNCTION db2_max_is_published_in_period(item_id_in CHARACTER(10),
                                               begin_time_in DATE)
  RETURNS INT
  READS SQL DATA
  LANGUAGE SQL
F1: BEGIN ATOMIC
    DECLARE result INT;
    SET result =
        (SELECT taupsm_result
           FROM db2_max_is_published_in_period_return_tbl t
           WHERE t.item_id = item_id_in AND
               t.begin_time <= begin_time_in AND
               begin_time_in < t.end_time);
    RETURN result;
END
-- end

-- sql
INSERT INTO item_id_tbl SELECT DISTINCT id, begin_time, end_time FROM item
-- end

-- sql
CALL db2_max_proc_is_published_in_period(CAST('1990-01-01' AS DATE),
                                         CAST('1995-01-01' AS DATE))
-- end

-- sql
SELECT i.title, CP.begin_time, CP.end_time
  FROM item i, CP
  WHERE db2_max_is_published_in_period(
      i.id, CP.begin_time) = 1 AND
    i.begin_time <= CP.begin_time AND
    CP.begin_time < i.end_time
-- end


