-----------------------------------------------------------------
-- Q10:
--   List the item titles ordered alphabetically by publisher
--   name, with release date within a certain time period
--   (from 1990-01-01 to 1995-01-01)
-- Feature:
--   IF without CURSOR
-----------------------------------------------------------------
-- init
CREATE TABLE TS (time_point DATE)
-- end

-- sql
INSERT INTO TS
  SELECT begin_time AS time_point FROM item
  UNION
  SELECT end_time AS time_point FROM item
  UNION
  SELECT begin_time AS time_point FROM publisher
  UNION
  SELECT end_time AS time_point FROM publisher
  UNION
  SELECT begin_time AS time_point FROM item_publisher
  UNION
  SELECT end_time AS time_point FROM item_publisher
-- end

-- init
CREATE VIEW CP AS
    SELECT * FROM (SELECT ts1.time_point AS begin_time,
                          ts2.time_point AS end_time
                     FROM TS AS ts1, TS AS ts2
                     WHERE ts1.time_point < ts2.time_point AND
                       $TIME_PERIOD
                       NOT EXISTS(
                         SELECT time_point FROM TS
                           WHERE time_point > ts1.time_point AND
                             time_point < ts2.time_point)
                           ORDER BY ts1.time_point) AS X
-- end


-- function
CREATE FUNCTION db2_max_item_of_90s(in_item_id CHARACTER (10),
                                     begin_time_in DATE)
  RETURNS INT
  READS SQL DATA
  LANGUAGE SQL
F1: BEGIN ATOMIC
    DECLARE rd DATE;
    SET rd =
     (SELECT date_of_release
        FROM item
	WHERE id = in_item_id AND
        begin_time <= begin_time_in AND
        begin_time_in <= end_time);
    IF (rd >= '1990-01-01') AND (rd < '1995-01-01')
    THEN RETURN 1;
    ELSE RETURN 0;
    END IF;
END
-- end

-- sql
SELECT i.title, p.name, CP.begin_time, CP.end_time
  FROM publisher p, item i, item_publisher ip, CP
  WHERE i.id = ip.item_id AND
    ip.publisher_id = p.publisher_id AND
    db2_max_item_of_90s(i.id, CP.begin_time) = 1 AND
    p.begin_time <= CP.begin_time AND
    CP.begin_time < p.end_time AND
    i.begin_time <= CP.begin_time AND
    CP.begin_time < i.end_time AND
    ip.begin_time <= CP.begin_time AND
    CP.begin_time < ip.end_time
  ORDER BY p.name
-- end

