----------------------------------------------------------------
-- Q7b:
--   Return item information where all its authors are from
--   certain country (Canada).
-- Feature:
--   REPEAT statement
----------------------------------------------------------------
CREATE FUNCTION all_author_from_country(bid CHARACTER(10),
                                        country CHARACTER(20))
  RETURNS BOOLEAN
  READS SQL DATA
  LANGUAGE SQL
  BEGIN
    DECLARE country_name CHARACTER(20);
    DECLARE country_cursor CURSOR FOR
        SELECT a.name_of_country
          FROM author a, item_author ia
          WHERE a.author_id = ia.author_id AND ia.item_id = bid;
    DECLARE country_not_found CONDITION FOR SQLSTATE '02000';
    OPEN country_cursor;
    FETCH country_cursor INTO country_name;
    REPEAT
      IF (country_name <> country)
      THEN
        BEGIN
          close country_cursor;
          RETURN FALSE;
        END;
      ELSE FETCH country_cursor INTO country_name;
      END IF;
      UNTIL country_not_found;
    END REPEAT;
    CLOSE country_cursor;
    RETURN TRUE;
  END;

SELECT * FROM item WHERE all_author_from_country(id, 'Canada');

