----------------------------------------------------------------
-- Q6:
--   Return item information where some authors are from
--   certain country (Canada).
-- Feature:
--   CASE statement
----------------------------------------------------------------
CREATE FUNCTION is_from_country(country_name VARCHAR(50),
                                country VARCHAR(50))
  RETURNS BOOLEAN
  READS SQL DATA
  LANGUAGE SQL
  BEGIN
    CASE WHEN (country_name = country)
    THEN
      RETURN TRUE;
    ELSE
      RETURN FALSE;
    END CASE;
  END;

SELECT DISTINCT i.*
  FROM item i, author a, item_author ia
  WHERE i.item_id = ia.item_id AND a.author_id = ia.author_id AND
      is_from_country(a.name_of_country, 'Canada');

