-- procedure
CREATE PROCEDURE proc_db2_all_author_from_country_b (item_id_in CHARACTER (10), country_in CHARACTER (20), OUT result_value INTEGER) NO EXTERNAL ACTION
READS SQL DATA
f1 : BEGIN
    DECLARE db2_return_result INTEGER;
    DECLARE country_name CHARACTER (20);
    DECLARE author_id_var CHARACTER(10);
    DECLARE country_name_var CHARACTER (20);
    DECLARE author_id_var2 CHARACTER (10);
    DECLARE item_id_var2 CHARACTER (10);
    DECLARE author_not_found CONDITION FOR SQLSTATE '02000';
    DECLARE item_author_not_found INTEGER;
    DECLARE author_cursor CURSOR FOR SELECT name_of_country
        FROM author;
    DECLARE item_author_cursor CURSOR FOR SELECT author_id, item_id
        FROM item_author
        WHERE author_id = author_id_var
            AND item_id = item_id_in;
    DECLARE CONTINUE HANDLER FOR author_not_found
       SET item_author_not_found =1;
    OPEN author_cursor;
    FETCH author_cursor INTO country_name_var, author_id_var;
    OPEN item_author_cursor;
    REPEAT
        FETCH item_author_cursor INTO author_id_var2, item_id_var2;
        IF (country_name_var <> country_in
            AND (NOT item_author_not_found = 1)) THEN

            BEGIN
                CLOSE author_cursor;
                CLOSE item_author_cursor;
                SET db2_return_result = 0;
            END;
            ELSE
                FETCH author_cursor INTO country_name_var, author_id_var;
        END IF;
    UNTIL item_author_not_found = 1
    END REPEAT;
    CLOSE author_cursor;
    CLOSE item_author_cursor;
    SET db2_return_result = 1;
    SET result_value = db2_return_result;
END

-- end
-- function
CREATE FUNCTION db2_all_author_from_country_b (item_id_in CHARACTER (10), country_in CHARACTER (20)) RETURNS INTEGER NO EXTERNAL ACTION
BEGIN
    DECLARE proc_result INTEGER;
    CALL proc_db2_all_author_from_country_b (item_id_in, country_in, proc_result);
    RETURN proc_result;
END

-- end
-- sql
SELECT *
    FROM item
    WHERE db2_all_author_from_country_b ('I7', 'Canada') = 1
-- end
