-- procedure
CREATE PROCEDURE proc_db2_all_author_from_country (bid CHARACTER (10), country CHARACTER (20), OUT result_value INTEGER) NO EXTERNAL ACTION READS SQL DATA LANGUAGE SQL
f1 : BEGIN
    DECLARE db2_return_result INTEGER;
    DECLARE country_name CHARACTER (20);
    DECLARE not_found INTEGER;
    DECLARE country_not_found CONDITION FOR SQLSTATE '02000';
    DECLARE country_cursor CURSOR FOR SELECT a.name_of_country
        FROM author a, item_author ia
        WHERE a.author_id = ia.author_id
            AND ia.item_id = bid;
    DECLARE CONTINUE HANDLER FOR country_not_found
      SET not_found=1;
    OPEN country_cursor;
    FETCH country_cursor INTO country_name;
    REPEAT
        IF (country_name <> country) THEN

            BEGIN
                CLOSE country_cursor;
                SET db2_return_result = 0;
            END
            ;
            ELSE
                FETCH country_cursor INTO country_name;
        END IF;
    UNTIL not_found = 1
    END REPEAT;
    CLOSE country_cursor;
    SET db2_return_result = 1;
    SET result_value = db2_return_result;
END

-- end
-- function
CREATE FUNCTION db2_all_author_from_country (bid CHARACTER (10), country CHARACTER (20)) RETURNS INTEGER NO EXTERNAL ACTION READS SQL DATA LANGUAGE SQL
BEGIN
    DECLARE proc_result INTEGER;
    CALL proc_db2_all_author_from_country (bid, country, proc_result);
    RETURN proc_result;
END

-- end
-- sql
SELECT *
    FROM item
    WHERE db2_all_author_from_country (CAST('I7'AS CHARACTER(10)), CAST ('Canada' AS CHARACTER (20))) = 1
-- end
