-- function
CREATE FUNCTION db2_get_release_date (item_id_in CHARACTER (10)) RETURNS DATE NO EXTERNAL ACTION READS SQL DATA LANGUAGE SQL
f1 : BEGIN
    RETURN (SELECT date_of_release
        FROM item
        WHERE item_id = item_id_in);
END

-- end
-- sql
SELECT p.name, SUM (i.quantity_in_stock)
    FROM item i, publisher p, item_publisher ip
    WHERE i.item_id = ip.item_id
        AND ip.publisher_id = p.publisher_id
        AND (db2_get_release_date (i.item_id) >= '1990-01-01'
            AND db2_get_release_date (i.item_id) <= '1991-01-01')
    GROUP BY p.name
-- end
