-- procedure
CREATE PROCEDURE proc_db2_is_released_in_period (pid CHARACTER (10), date1 DATE, date2 DATE, OUT result_value INTEGER) NO EXTERNAL ACTION READS SQL DATA LANGUAGE SQL
f1 : BEGIN
    DECLARE item_id_var CHARACTER (10);
    DECLARE no_tuple CONDITION FOR SQLSTATE '02000';
    DECLARE item_cursor CURSOR FOR SELECT i.item_id
        FROM item i, item_publisher ip
        WHERE i.item_id = ip.item_id
            AND ip.publisher_id = pid
            AND (i.date_of_release >= date1
                AND i.date_of_release <= date2);
    DECLARE CONTINUE HANDLER FOR no_tuple
       SET result_value=0;
    SET result_value=1;
    OPEN item_cursor;
    FETCH item_cursor INTO item_id_var;
    CLOSE item_cursor;
END

-- end
-- function
CREATE FUNCTION db2_is_released_in_period (pid CHARACTER (10), date1 DATE, date2 DATE) RETURNS INTEGER NO EXTERNAL ACTION READS SQL DATA LANGUAGE SQL
BEGIN
    DECLARE proc_result INTEGER;
    CALL proc_db2_is_released_in_period (pid, date1, date2, proc_result);
    RETURN proc_result;
END

-- end
-- sql
SELECT name
    FROM publisher
    WHERE db2_is_released_in_period (publisher_id, CAST ('1990-01-01' AS DATE), CAST ('1991-01-01' AS DATE)) = 1
        AND fax_number IS NULL
-- end
