----------------------------------------------------------------
-- Q7:
--   Return item information where all its authors are from
--   certain country (Canada).
-- Feature:
--   WHILE statement
----------------------------------------------------------------
-- procedure
CREATE PROCEDURE db2_orig_proc_all_author_from_country(
    IN item_id_in CHARACTER(10),
    IN country_in VARCHAR(50),
    OUT taupsm_result INT)
  NO EXTERNAL ACTION
  READS SQL DATA
P1: BEGIN
    DECLARE country_name VARCHAR(50);
    DECLARE total_count INT;
    DECLARE SQLCODE INTEGER DEFAULT 0;
    DECLARE country_cursor CURSOR FOR
        SELECT a.name_of_country
          FROM author a, item_author ia
          WHERE a.author_id = ia.author_id AND ia.item_id = item_id_in;
    SET taupsm_result = 1;
    SET total_count = 0;
    OPEN country_cursor;
    FETCH country_cursor INTO country_name;
    while1: WHILE SQLCODE = 0 DO
      SET total_count = total_count + 1;
      IF (country_name <> country_in)
        THEN
          SET taupsm_result = 0;
          LEAVE while1;
        ELSE FETCH country_cursor INTO country_name;
      END IF;
    END WHILE;
    CLOSE country_cursor;
    IF (total_count = 0)
      THEN SET taupsm_result = 0;
    END IF;
END
-- end


-- function
CREATE FUNCTION DB2_ORIG_ALL_AUTHOR_FROM_COUNTRY(item_id_in CHARACTER(10),
                                                 country_in VARCHAR(50))
  RETURNS INT
  NO EXTERNAL ACTION
F1: BEGIN ATOMIC
	DECLARE taupsm_result INT;
	CALL db2_orig_proc_all_author_from_country(
	    item_id_in, country_in, taupsm_result);
    RETURN taupsm_result;
END
-- end


-- sql
SELECT * FROM item
  WHERE db2_orig_all_author_from_country(item_id, CAST('Canada' AS VARCHAR(50))) = 1
-- end


