----------------------------------------------------------------
-- Q6:
--   Return item information where some authors are from
--   certain country (Canada).
-- Feature:
--   CASE statement
----------------------------------------------------------------
-- procedure
CREATE PROCEDURE db2_orig_proc_is_from_country(IN country_name VARCHAR(50),
                                               IN country VARCHAR(50),
                                               OUT taupsm_result INT)
  NO EXTERNAL ACTION
  READS SQL DATA
P1: BEGIN
    CASE
      WHEN country_name = country THEN
        SET taupsm_result = 1;
      ELSE
        SET taupsm_result = 0;
    END CASE;
END
-- end

-- function
CREATE FUNCTION db2_orig_is_from_country(country_name VARCHAR(50),
                                         country VARCHAR(50))
  RETURNS INT
  NO EXTERNAL ACTION
F1: BEGIN ATOMIC
    DECLARE taupsm_result INT;
    CALL db2_orig_proc_is_from_country(country_name, country,
                                                taupsm_result);
    RETURN taupsm_result;
END
-- end

-- sql
SELECT DISTINCT i.*
  FROM item i, author a, item_author ia
  WHERE i.item_id = ia.item_id AND a.author_id = ia.author_id AND
    db2_orig_is_from_country(a.name_of_country,
                             CAST('Canada' AS VARCHAR(50))) = 1
-- end


