----------------------------------------------------------------
-- Q3:
--   Group items released in a certain year (1990),
--   by publisher name and calculated the total number of
--   items for each group.
-- Feature:
--   RETURN with SELECT single row
----------------------------------------------------------------
-- function
CREATE FUNCTION db2_orig_get_release_date(item_id_in CHARACTER(10))
  RETURNS DATE
  NO EXTERNAL ACTION
F1: BEGIN ATOMIC
    RETURN (SELECT date_of_release FROM item WHERE item_id = item_id_in);
END
-- end

-- sql
SELECT p.name, SUM(i.quantity_in_stock)
  FROM item i, publisher p, item_publisher ip
  WHERE i.item_id = ip.item_id AND ip.publisher_id = p.publisher_id
    AND db2_orig_get_release_date(i.item_id) >= '1990-01-01'
    AND db2_orig_get_release_date(i.item_id) <= '1991-01-01'
  GROUP BY p.name
-- end

