----------------------------------------------------------------
-- Q17b:
--   Return the first n ids of the items whose descriptions
--   contain a certain word ("hockey") and for which the number
--   of pages is less than 500 if at least one author is Canadian.
--   (n is an input parameter)
--   Also return the relevant date for each id.
--   If all n are evaluated, results will be sorted by id.
-- Feature:
--   1. many time-varying variables
--   2. two time-varying tables
--   3. nested loop
--   4. multiple FETCHes in a loop
--   5. multiple SET of variables
--   6. a FETCH in the ELSE but not in the THEN part
--   7. function call and 
--   8. LEAVE statement
--   9. Both CURSOR and FOR 
--  10. INSERT and ELSE statement on arrays
----------------------------------------------------------------

-- function
CREATE FUNCTION db2_orig_is_small_book(item_id_in CHARACTER(10))
  RETURNS INT
  READS SQL DATA
  LANGUAGE SQL
F1: BEGIN ATOMIC
    DECLARE num_pages INT;
    SET num_pages =
        (SELECT number_of_pages FROM item WHERE item_id = item_id_in);
    IF (num_pages <= 7500)
      THEN RETURN 1;
      ELSE RETURN 0;
    END IF;
  END
-- end

-- procedure
CREATE PROCEDURE db2_orig_proc_has_canadian_author(
    IN item_id_in CHARACTER(10), OUT has_canadian INT)
  READS SQL DATA
  LANGUAGE SQL
P1: BEGIN
    IF (EXISTS(SELECT a.name_of_country
            FROM item_author ia, author a
            WHERE ia.item_id = item_id_in AND a.author_id = ia.author_id AND
              a.name_of_country = 'Venezuela'))
      THEN SET has_canadian = 1;
      ELSE SET has_canadian = 0;
    END IF;
  END
-- end



-- procedure
CREATE PROCEDURE db2_orig_proc_get_first_n_items_about_hockey(IN first_n INT)
  MODIFIES SQL DATA
  LANGUAGE SQL
P1: BEGIN
    DECLARE temp_item_id CHARACTER(10);
    DECLARE temp_when_is_available DATE;
    DECLARE temp_date_of_release DATE;
    DECLARE relevant_date DATE;
    DECLARE has_canadian INT;
    DECLARE count INT;
    DECLARE taupsm_status INT DEFAULT 0;
    DECLARE hockey_not_found CONDITION FOR SQLSTATE '02000';
    DECLARE temp_int INT;
    DECLARE all_items_cur CURSOR FOR
      SELECT i.item_id AS item_id, i.when_is_available AS when_is_available,
             i.date_of_release AS date_of_release
        FROM item i
        WHERE i.description LIKE '%hockey%';
    DECLARE CONTINUE HANDLER FOR hockey_not_found SET taupsm_status = 1;
    SET count = 0;
    OPEN all_items_cur;
    FETCH all_items_cur INTO
        temp_item_id, temp_when_is_available, temp_date_of_release;
    while_loop: WHILE (taupsm_status = 0) DO
      CALL db2_orig_proc_has_canadian_author(temp_item_id, has_canadian);
      SET temp_int = db2_orig_is_small_book(temp_item_id);
      IF ((has_canadian = 1) AND ( temp_int = 1))
        THEN 
          IF (MOD(count, 2) = 0)
            THEN
              SET relevant_date = temp_when_is_available;
            ELSE
              SET relevant_date = temp_date_of_release;
          END IF;
          INSERT INTO temp_item_id_tbl VALUES (
              temp_item_id, relevant_date);
          SET count = count + 1;
          IF (count >= first_n)
            THEN
              FOR temp_item_id_order AS
                SELECT * FROM temp_item_id_tbl ORDER BY taupsm_item_id
              DO
                INSERT INTO return_item_id_tbl
                    VALUES(temp_item_id_order.taupsm_item_id,
                           temp_item_id_order.sometime);
              END FOR;
              LEAVE while_loop;
            ELSE FETCH all_items_cur INTO
              temp_item_id, temp_when_is_available, temp_date_of_release;
          END IF;
        ELSE FETCH all_items_cur INTO
          temp_item_id, temp_when_is_available, temp_date_of_release;
      END IF;
    END WHILE;
    CLOSE all_items_cur;
  END
-- end

-- sql
CALL db2_orig_proc_get_first_n_items_about_hockey(2)
-- end

-- sql
SELECT * FROM return_item_id_tbl
-- end

