----------------------------------------------------------------
-- Q14:
--   Return the names of publishers who publish books between
--   a period of time from 1990-01-01 to 1991-01-01 but
--   do not have FAX number.
-- Feature:
--   Local cursor declaration
--   FETCH, OPEN, and CLOSE statements
----------------------------------------------------------------
-- procedure
CREATE PROCEDURE db2_orig_proc_is_released_in_period(
    IN pid CHARACTER(10),
    IN date1 DATE, IN date2 DATE,
    OUT taupsm_result INT)
  NO EXTERNAL ACTION
  READS SQL DATA
P1: BEGIN
    DECLARE item_id_result CHARACTER(10);
    DECLARE no_tuple CONDITION FOR SQLSTATE '02000';
    DECLARE item_cursor CURSOR FOR
        SELECT i.item_id FROM item_publisher ip, item i
          WHERE ip.publisher_id = pid
            AND i.item_id = ip.item_id
            AND i.date_of_release BETWEEN date1 AND date2;
    DECLARE CONTINUE HANDLER FOR no_tuple
      SET taupsm_result = 0;
    SET taupsm_result = 1;
    OPEN item_cursor;
    FETCH item_cursor INTO item_id_result;
    CLOSE item_cursor;
END
-- end

-- function
CREATE FUNCTION db2_orig_is_released_in_period(pid CHARACTER(10),
                                               date1 DATE,
                                               date2 DATE)
  RETURNS INT
  NO EXTERNAL ACTION
F1: BEGIN ATOMIC
  DECLARE result INT;
  CALL db2_orig_proc_is_released_in_period(pid, date1, date2, result);
  RETURN result;
END
-- end

-- sql
SELECT name FROM publisher
  WHERE db2_orig_is_released_in_period(publisher_id,
                                       CAST('1990-01-01' AS DATE),
                                       CAST('1991-01-01' AS DATE)) = 1 AND
    fax_number IS NULL
-- end


