----------------------------------------------------------------
-- Q11:
--   List the item titles in descending order by date of
--   release with date of release within a certain time
--   range (from 1990-01-01 to 1995-01-01).
-- Feature:
--   Temporary Table Creation
----------------------------------------------------------------
-- procedure
CREATE PROCEDURE DB2_ORIG_PROC_IS_PUBLISHED_IN_PERIOD (
    IN item_id_in CHARACTER(10), OUT taupsm_result INT)
  LANGUAGE SQL
P1: BEGIN
  DECLARE GLOBAL TEMPORARY TABLE temp_item AS
      (SELECT * FROM item) DEFINITION ONLY;
  P2: BEGIN
    INSERT INTO session.temp_item SELECT * FROM item;
    IF (EXISTS (SELECT * FROM session.temp_item
                  WHERE item_id = item_id_in AND
                    date_of_release BETWEEN '1990-01-01' AND '1995-01-01'))
    THEN SET taupsm_result = 1;
    ELSE SET taupsm_result = 0;
    END IF;
  END P2;
  DROP TABLE session.temp_item;
END P1
-- end

-- function
CREATE FUNCTION db2_orig_is_published_in_period(item_id CHARACTER(10))
  RETURNS TABLE(taupsm_result INT)
  MODIFIES SQL DATA
  LANGUAGE SQL
F1: BEGIN ATOMIC
    DECLARE taupsm_result INT;
    CALL db2_orig_proc_is_published_in_period(
        item_id, taupsm_result);
    RETURN VALUES(taupsm_result);
END
-- end

-- sql
WITH result AS (SELECT taupsm_result from TABLE (db2_orig_is_published_in_period(CAST('I10' AS CHARACTER(10)))))
SELECT i.title
  FROM item i, result t
  WHERE t.taupsm_result = 1
-- end

