#!/usr/bin/perl


$dir = "";
@files = ("TCSD.tsl","TCMD.tsl","DCSD.tsl","DCMDOrd.tsl","DCMDCust.tsl",
"DCMDItem.tsl","DCMDAuth.tsl","DCMDAddr.tsl","DCMDCoun.tsl");
@digsyl = ("BA", "OG", "AL", "RI", "RE", "SE", "AT", "UL", "IN", "NG");
@limit = (1,1,4,9,9,9,9,9,9);

#scaling parametes
@tcsd = (733,7333,73333,733333);
@tcmd = (26,266,2666,26666);
@dcsd = (2500,25000,250000,2500000);

@order = (2592,25920,259200,2592000);
@customer = (2880,28800,288000,2880000);
@item = (1000,10000,100000,1000000);
@author = (250,2500,25000,250000);
@address = (5760,57600,576000,5760000);
@country = (92,92,92,92);

# By default,XBench does not generate thumbnail/image data for
# XML documents in classes DC/SD and DC/MD. However, you can
# change the values of $want_thumbnail or $want_image to 1,
# if you want them to be generated. 
@thumbnail = (0,1);
@image = (0,1);
$want_thumbnail = 0;
$want_image = 0;

$count = 0;

#print time;
print " -----------------------------------\n";
print "|   XBench Database Generator v1.0  |\n";
print "| (c)2002 by University of Waterloo |\n";
print " -----------------------------------\n\n";
print "Database Class: [1]TC/SD [2]TC/MD [3]DC/SD [4]DC/MD\n";
print "Please choose database class (any other key to exit): ";
$database = <STDIN>;
chop($database);
# exit if proper choice not enteres
if (($database != 1) and ($database != 2) and ($database != 3) and 
    ($database != 4)) {
  print "User chose to exit, exiting...\n";
  exit(0);
}

print "\n";
print "Database Size: [1]Small [2]Normal [3]Large [4]Huge\n";
print "Please choose database size (default is Normal): ";
$size = <STDIN>;
chop($size);

print "\n";
# check if the option provided is valid.... work with default 
# option otherwise
if (($size != 1) and ($size != 2) and ($size != 3) and ($size != 4)){
  print "Working with default size...\n";
  $size = 2;
}

#get current date
  
($Second, $Minute, $Hour, $Day, $Month, $Year, $WeekDay, $DayOfYear, 
 $IsDST) = localtime(time);
$c_year = $Year+1900;
$c_month = $Month+1;
if ($c_month < 10)
  {$c_month = '0' . $c_month;}
$c_day = $Day;
if ($c_day < 10)
  {$c_day = '0' . $c_day;}
$current_date = $c_year . '-'  . $c_month . '-' . $c_day;
#print $current_date . "\n";

if ($database < 4) {
  $filename = $dir . "templates/" . $files[$database - 1];
  $newfile  = ">" . $dir . "templates/new" . $files[$database - 1];
  print "Generating template " . $filename . "==" . $newfile . "\n";
  
  open(file,$filename) or die "Can't open" . $file_name . ": $!";
  open(nfile,$newfile) or die "Can't open" .  $newfile . 
    " for writing: $!";
  
    while ($line = <file>){
      
      if ($line =~ /ENTITY/){
    $count++;
    
    if ($count > $limit[$database - 1]) {
      print nfile $line;
        }
    else {
      $pos = index($line,"ENTITY");
      $pos = $pos + 7;
      $end = index($line," ",$pos);
      $val = index($line,"\">",$end + 1);
      $defaultvalue = substr($line,$end + 1,$val - $end);
      if ($database == 1) {
        $response = $tcsd[$size -1];
      }
      elsif ($database == 2) {
        $response = $tcmd[$size -1];
      }
      elsif ($database == 3) {
        if ($count == 1 ) {
          $response = $dcsd[$size -1];
        }
        if ($count == 2) {
          $response = $current_date;
        }
        if ($count == 3) {
          $response = $thumbnail[$want_thumbnail];
        }
        if ($count == 4) {
          $response = $image[$want_image];
        }
      }
      else {
      }
      
      $newline = substr($line,0,$end + 2) . $response . "\">\n";
      print nfile $newline;
    }
      }
      else {
    print nfile $line;
      }
    }
  close(file);
  close(nfile);
  
  if ($database == 3) {
    #call tpcw wgen to generate titles and lastnames
    #transfer text file into xml file
    print "\n";
    print "Generating TPC-W titles/lastnames ...\n";
    
    system 'wgen/tpcw -d wgen/grammar.tpcw -i' . $dcsd[$size-1] . 
      ' >temp/titles.txt';
    
    open(txt, $dir."temp/titles.txt");
    open(xml, $dir.">input/titles.xml");
    print xml "<?xml version=\"1.0\"?>\n";
    print xml "<titles>\n";
    while(<txt>) {
      chop;
      s/\s//g;
      $line = $_;
      if (length($line) > 0) {
    print xml "<title>" . $line . "</title>\n";
      }
    }
    print xml "</titles>\n";
    close(txt);
    close(xml);
    
    system 'wgen/tpcw -d wgen/grammar.tpcw -a' . ($dcsd[$size-1])/4 . 
      ' -m1 >temp/lnames.txt';
    
    open(txt, $dir."temp/lnames.txt");
    open(xml, $dir.">input/lnames.xml");
    print xml "<?xml version=\"1.0\"?>\n";
    print xml "<lnames>\n";
    while(<txt>) {
      chop;
      s/\s//g;
      $line = $_;
      if (length($line) > 0) {
    print xml "<lname>" . $line . "</lname>\n";
      }
    }
    print xml "</lnames>\n";
    close(txt);
    close(xml);
  }
  #call toxgene    
  print "\n";
  system 'toxgene/toxgene -t -n ' . $dir . 'templates/new' . $files[$database - 1];
  #print "\n";
}
else {
  
  for ($i = 4;$i < 10;$i = $i + 1){
    
    $count = 0;
    $filename = $dir . "templates/" . $files[$i - 1];
    $newfile  = ">" . $dir . "templates/new" . $files[$i - 1];
    print "Generating template " . $filename . "==" . $newfile . "\n";
    
    open(file,$filename) or die "Can't open" . $file_name . ": $!";
    open(nfile,$newfile) or die "Can't open" .  $newfile . 
      " for writing: $!";
    
    while ($line = <file>){
      
      if ($line =~ /ENTITY/){
    $count++;
    
    if ($count > $limit[$database - 1]) {
      print nfile $line;
    }
    else {
      
      $pos = index($line,"ENTITY");
      $pos = $pos + 7;
      $end = index($line," ",$pos);
      $val = index($line,"\">",$end + 1);
      $defaultvalue = substr($line,$end + 1,$val - $end);
      if ($count == 1) {
        $response = $order[$size -1];
      }
      elsif ($count == 2) {
        $response = $customer[$size -1];
      }
      elsif ($count == 3) {
        $response = $item[$size -1];
      }
      elsif ($count == 4) {
        $response = $author[$size -1];
      }
      elsif ($count == 5) {
        $response = $address[$size -1];
      }
      elsif ($count == 6) {
        $response = $country[$size -1];
      }
      elsif ($count == 7) {
        $response = $current_date;
      }
      elsif ($count == 8) {
        $response = $thumbnail[$want_thumbnail];
      }
      elsif ($count == 9) {
        $response = $image[$want_image];
      }
      else {
      }
      
      $newline = substr($line,0,$end + 2) . $response . "\">\n";
      print nfile $newline;
    }
      }
      else {
    print nfile $line;
      }
    }
    close(file);
    close(nfile);
  }
  print "\n";
  
  # generate usernames/passwords according to TPC-W digsyl function
  print "Generating TPC-W usernames/passwords ...\n";

  open(file, $dir . ">input/digsyl.xml");
  print file "<?xml version=\"1.0\"?>\n";
  print file "<customers>\n"; 
  for ($i=1; $i<= $customer[$size-1]; $i++) {
    print file "<customer>\n";
    print file "<id>" . $i . "</id>\n";
    $str = '';
    $id_len = length($i);
    for ($j=0; $j<$id_len; $j++) {
      $str = $str . $digsyl[substr($i, $j, 1)];
    }
    #print $str . "\n";
    print file "<name>" . $str . "</name>\n";
    print file "<password>" . lc($str) . "</password>\n";
    print file "</customer>\n";
  }
  print file "</customers>\n";
  close(file);
  
  # call tpcw wgen to generate titles and lastnames
  # transfer text file into xml file
  print "Generating TPC-W titles/lastnames ...\n";

  system 'wgen/tpcw -d wgen/grammar.tpcw -i' . $item[$size-1] . 
    ' >temp/titles.txt'; 
  
  open(txt, $dir."temp/titles.txt");
  open(xml, $dir.">input/titles.xml");
  print xml "<?xml version=\"1.0\"?>\n";
  print xml "<titles>\n";
  while(<txt>) {
    chop;
    s/\s//g;
    $line = $_;
    if (length($line) > 0) {
      print xml "<title>" . $line . "</title>\n";
    }
  }
  print xml "</titles>\n";
  close(txt);
  close(xml);
  
  system 'wgen/tpcw -d wgen/grammar.tpcw -a' . $author[$size-1] . 
    ' -m1 >temp/lnames.txt';
 
  open(txt, $dir."temp/lnames.txt");
  open(xml, $dir.">input/lnames.xml");
  print xml "<?xml version=\"1.0\"?>\n";
  print xml "<lnames>\n";
  while(<txt>) {
    chop;
    s/\s//g;
    $line = $_;
    if (length($line) > 0) {
      print xml "<lname>" . $line . "</lname>\n";
    }
      }
  print xml "</lnames>\n";
  close(txt);
  close(xml);

  #call toxgene
  print "\n";
  #    for ($i = 4;$i < 10;$i = $i +1){
  # exec 'toxgene -t -n new' . $files[$i-1];
  
  for ($i = 4;$i <= 9;$i = $i +1){
    #$pid = fork();
    #if ($pid == 0) {
    #}
    #else {
    system 'toxgene/toxgene -t -n ' . $dir . 'templates/new' . $files[$i-1];
    #  exit(0);
    #}
  }
}

# fix the togene bug
# by getting rid of comma sign in the filenames.
#print "\n";
#print "Cleaning up temporary files ...\n";
#print "This may take a while. Please be patient.\n";
#system "perl change.pl";
print "Done.\n";
