/**
 * 
 */
package cs.arizona.util;

import java.util.*;
import java.io.*;

/**
 * @author Shailesh Joshi
 *
 */
public class ValidatorProperties { 

	private Properties propTable;
	private static ValidatorProperties validatorProperties;
	
	public static String PROPERTY_FILE_NAME = "etc/properties.txt";

	/**
	 * 
	 */
	private ValidatorProperties() {
		super();
		try{
		propTable = new Properties();
		FileInputStream in = new FileInputStream(new File(System.getenv("TXSCHEMA_HOME") + "/" + PROPERTY_FILE_NAME));
		/*
		InputStream in =
            getClass().getClassLoader().getResourceAsStream(
                System.getenv("TXSCHEMA_HOME") + "/" + PROPERTY_FILE_NAME);
                */
		propTable.load(in);
		//propTable.list(System.out);
		in.close();
		}catch(Exception e){
			System.err.println("Unable to open Properties file: " +
                               PROPERTY_FILE_NAME);
		}
	}

	public static ValidatorProperties getInstance(){
		if (null == validatorProperties){
			validatorProperties = new ValidatorProperties();
		}
		return validatorProperties;
	}
	
	public String getProperty(String name){
		return propTable.getProperty(name);
	}
}
