/**
 * 
 */
package cs.arizona.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.StringWriter;
import java.net.URI;

import org.w3c.dom.*;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.*;



import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.OutputKeys;




/**
 * @author Shailesh Joshi
 *
 */
public class ConventionalParser {

	private LSParser lsParser;
	private LSSerializer lsSerializer;
	private LSOutput lsOutput;
	private LSInput lsInput;
	private DOMImplementation impl;
	
	private static ConventionalParser conventionalParser;
	/**
	 * 
	 */
	private ConventionalParser() {
		super();
        try {
            // get DOM Implementation using DOM Registry
            System.setProperty(DOMImplementationRegistry.PROPERTY,"org.apache.xerces.dom.DOMXSImplementationSourceImpl");
            DOMImplementationRegistry registry =
                DOMImplementationRegistry.newInstance();

            DOMImplementationLS implLS = 
                (DOMImplementationLS)registry.getDOMImplementation("LS");
            lsParser = implLS.createLSParser(DOMImplementationLS.MODE_SYNCHRONOUS, null);
            lsSerializer = implLS.createLSSerializer();
            lsOutput = implLS.createLSOutput();
            lsInput = implLS.createLSInput();
            
            impl = registry.getDOMImplementation("XML 3.0");
        }catch (Exception e){
        	e.printStackTrace();
        }
	}
	
	public static ConventionalParser getInstance(){
		if (null == conventionalParser){
			conventionalParser = new ConventionalParser();
		}
		return conventionalParser;
	}
	
	/* To make the "validate" parameter true by default. */
	public Document parseDocument(String documentPath, String schemaType, String schemaLocation){ 
		return parseDocument( documentPath,  schemaType,  schemaLocation, true);
	}
	
	
	/**
	 * 
	 * @param documentPath
	 * @param schemaType
	 * @param schemaLocation
	 * @param vl
	 * @return
	 * @throws DOMException
	 * @throws LSException
	 */
	public Document parseDocument(String documentPath, String schemaType, String schemaLocation, boolean vl) 
	throws DOMException, LSException{
		Document document;
		try {
			//TODO: Common.checkFileExists(documentPath);
			// Debug output
			TauLogger.logger.info("Parsing document \"" + documentPath + "\"" );
			
			DOMConfiguration domConfig = lsParser.getDomConfig();
			
			schemaType = "http://www.w3.org/2001/XMLSchema";
			domConfig.setParameter("schema-type", schemaType);
			String processed_schema_location = schemaLocation;
			if (schemaLocation != null && schemaLocation.startsWith("etc")) {
				processed_schema_location = System.getenv("TXSCHEMA_HOME") + "/" + processed_schema_location; 				
			}
            domConfig.setParameter("schema-location", processed_schema_location);
            domConfig.setParameter("validate", vl);
            //document = lsParser.parseURI(documentPath);
            document = lsParser.parseURI(documentPath);
         // DEBUG writeDocument(document, "test1_" + documentPath + ".xsd");
		}catch (DOMException e){
			e.printStackTrace(); 	
			throw e;
		}catch (LSException e){
			System.out.println("Error Unable to parse document: " + documentPath);
			e.printStackTrace(); 
			throw e;
		}catch (Exception e){
			e.printStackTrace();
			return null;
		}
		return document;
	}

	public void writeDocument(Document doc, String path){
		try{
			TauLogger.logger.info("Writing document \"" + path + "\"" );
			
			TransformerFactory tf = TransformerFactory.newInstance();
		    Transformer transformer = tf.newTransformer();
		    
		    transformer.setOutputProperty(OutputKeys.OMIT_XML_DECLARATION, "no");
		    transformer.setOutputProperty(OutputKeys.INDENT, "yes");
		    transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2" );

		    DOMSource source = new DOMSource(doc);          
		    StreamResult result = new StreamResult(new FileOutputStream(path));  
		    transformer.transform(source, result);

			
	    } catch (Exception e) {
	    	e.printStackTrace();
	    }
	}
	
	
	public void writeElement(Element element, String path){
		TauLogger.logger.info("Writing element to file \"" + path + "\"" );
		try{
			TransformerFactory tf = TransformerFactory.newInstance();
		    Transformer transformer = tf.newTransformer();
		    
		    transformer.setOutputProperty(OutputKeys.OMIT_XML_DECLARATION, "no");
		    transformer.setOutputProperty(OutputKeys.INDENT, "yes");
		    transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2" );

		    DOMSource source = new DOMSource(element);          
		    StreamResult result = new StreamResult(new FileOutputStream(path));  
		    transformer.transform(source, result);
	    }catch (Exception e){
	    	e.printStackTrace();
	    }
	}
	
	
	public Document createDocument(String namespaceURI, String qualifiedName, DocumentType docType){
		return impl.createDocument(namespaceURI, qualifiedName, docType);
	}
	
	public Document parseURI(String documentPath){

		DOMConfiguration domConfig = lsParser.getDomConfig();
		domConfig.setParameter("schema-type", null);
        domConfig.setParameter("schema-location",null);
        domConfig.setParameter("validate", Boolean.FALSE);

		return lsParser.parseURI(documentPath);
	}
}
