package cs.arizona.tau.xml.temporalconstraint;

import static org.junit.Assert.*;

import java.util.Vector;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import cs.arizona.tau.docs.ConstantSchemaTemporalDocument;
import cs.arizona.tau.docs.TemporalSchema;
import cs.arizona.tau.xml.Common;
import cs.arizona.tau.xml.LogicalAnnotationValidator;
import cs.arizona.tau.xml.PhysicalAnnotationValidator;
import cs.arizona.util.ConventionalParser;
import cs.arizona.util.TargetIdentifier;
import cs.arizona.util.ValidatorProperties;

public class TransitionConstraintTest {
  Document temporal_doc_;
  Document annotation_doc_;
  Document schema_doc_;
  Applicability default_applicability_;
  Vector<Constraint> constraints_;
  TemporalConstraintValidator tcv_;

  @BeforeClass
  public static void setUpBeforeClass() throws Exception {
  }

  @AfterClass
  public static void tearDownAfterClass() throws Exception {
  }

  @Before
  public void setUp() throws Exception {
    constraints_ = new Vector<Constraint>();
    String temporalSchema =
        "test_suites/ts_transition.xml";
    Document input_temporal_doc =
  	  ConventionalParser.getInstance().parseDocument(
            "test_suites/output.final.xml", null, null, false);
    tcv_ = new TemporalConstraintValidator(
        input_temporal_doc, temporalSchema);
    temporal_doc_ = tcv_.GetTemporalDocument();
    annotation_doc_ = tcv_.GetAnnotationDocument();
    tcv_.ExtractConstraints(
        annotation_doc_.getDocumentElement(), "transitionConstraint",
        constraints_);
  }

  @After
  public void tearDown() throws Exception {
  }

  @Test
  public void testCheckTransitionConstraint() {
    int num_constraints = constraints_.size();
    Assert.assertEquals(0, num_constraints);
    /*
    Vector<Constraint> constraint1 = new Vector<Constraint>();
    constraint1.add(constraints_.get(0));
    Vector<Constraint> constraint2 = new Vector<Constraint>();
    constraint2.add(constraints_.get(1));
    boolean val1 = TransitionConstraint.CheckTransitionConstraint(
        temporal_doc_, constraint1);
    Assert.assertFalse(val1);
    boolean val2 = TransitionConstraint.CheckTransitionConstraint(
        temporal_doc_, constraint2);
    Assert.assertFalse(val2);
    */
  }

}
