package cs.arizona.tau.xml.temporalconstraint;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;

import org.w3c.dom.Document;
import org.w3c.dom.Node;

import cs.arizona.tau.xml.TXSchemaConstants;

class ValuePair {
  public String old_val_;
  public String new_val_;
  public ValuePair(String old_val, String new_val) {
    old_val_ = old_val;
    new_val_ = new_val;
  }
}


/**
 * The <code>TransitionConstraint</code> sub-class extending
 * <code>Constraint</code>
 * @author ruizhang
 *
 */
public class TransitionConstraint extends Constraint {
  protected String value_evolution_;
  protected TreeSet<String> value_pair_set_ = null;
  protected int mode_;
  /**
   * Value Evolution mode
   */
  public static int VALUEEVOLUTION = 0;
  /**
   * Value Pair mode
   */
  public static int VALUEPAIR = 1;

  
  /**
   * Constructing the <code>TransitionConstraint</code> instance
   * in the value-evolution mode, with its
   * specific attribute, which is <code>direction</code>.
   * @param name
   * @param dimension
   * @param selector
   * @param field
   * @param evaluation_window
   * @param slide_size
   * @param applicability
   * @param direction the value evolution direction
   */
  public TransitionConstraint(String name,
                              String item_target, String item_identifier,
		                      String dimension, String selector,
                              String field,
                              int evaluation_window, int slide_size,
                              Applicability applicability,
                              String direction) {
    super(name, item_target, item_identifier,
          dimension, selector, field, evaluation_window, slide_size,
          applicability);
    value_evolution_ = direction;
    mode_ = VALUEEVOLUTION;
  }
  
  /**
   * Constructing the <code>TransitionConstraint</code> instance
   * in the value-pair mode, with its
   * specific attribute, which is <code>direction</code>.
   * @param name
   * @param dimension
   * @param selector
   * @param field
   * @param evaluation_window
   * @param slide_size
   * @param applicability
   * @param value_pairs the set of possible value pairs
   */
  public TransitionConstraint(String name,
		                      String item_target, String item_identifier,
                              String dimension, String selector,
                              String field,
                              int evaluation_window, int slide_size,
                              Applicability applicability,
                              Vector<ValuePair> value_pairs) {
    super(name, item_target, item_identifier,
          dimension, selector, field, evaluation_window, slide_size,
          applicability);
    value_pair_set_ = new TreeSet<String>();
    for (ValuePair vp : value_pairs) {
      value_pair_set_.add(vp.old_val_ + "-" + vp.new_val_);
    }
    mode_ = VALUEPAIR;
  }
    
    
  public String getDirection() {
    return value_evolution_;
  }
  
  
  public TreeSet<String> getValuePairSet() {
    return value_pair_set_;
  }
  
  
  public int getMode() {
    return mode_;
  }
  
  
  /**
   * Checking constraint 6.4 the <code>TransitionConstraint</code> constraint
   * for both the value-evolution and value-pair cases.
   * @param temporal_doc the temporal document
   * @param constraints the list of defined <code>TransitionConstraint</code>
   * constraints
   */
  public static boolean CheckTransitionConstraint(
      Document temporal_doc, Vector<Constraint> constraints) {
    if (constraints == null) {
      return true;
    }
    for (Constraint c : constraints) {
      for (Applicability app : c.eval_windows_) {
        String xpath_query = TemporalConstraintValidator.PrepareXPathString(
            c.getSelector(), c.getField());
        xpath_query += "|" +  c.getItemIdentifier();
        Vector<String> result_nodes =
            TemporalConstraintValidator.GetCandidateNodes(
                temporal_doc, xpath_query,
                c.getItemTarget(), c.getItemIdentifier(),  app);
        if (result_nodes == null) {
          return false;
        }
        Map<String, Vector<String>> value_map =
        	new HashMap<String, Vector<String>>();
        for (String node_content : result_nodes) {
          String[] key_value = node_content.split(TXSchemaConstants.DELIMITER);
          if (value_map.containsKey(key_value[0])) {
            Vector<String> temp_values = value_map.get(key_value[0]);
            temp_values.add(key_value[1]);
          } else {
            Vector<String> cand_values = new Vector<String>();
            cand_values.add(key_value[1]);
            value_map.put(key_value[0], cand_values);
          } 
        }
        if (((TransitionConstraint)c).getMode() ==
              TransitionConstraint.VALUEEVOLUTION) {
          Set<String> key_set = value_map.keySet();
          for (String key : key_set) {
            Vector<String> temp_values = value_map.get(key);
            for (int i = 0; i < temp_values.size() - 1; ++i) {
              String direction = ((TransitionConstraint)c).getDirection();
              if ((direction.equals("LE") &&
                  Integer.parseInt(temp_values.get(i)) >
                  Integer.parseInt(temp_values.get(i + 1))) ||
                  (direction.equals("GE") &&
                  Integer.parseInt(temp_values.get(i)) <
                  Integer.parseInt(temp_values.get(i + 1))) ||
                  (direction.equals("LT") &&
                  Integer.parseInt(temp_values.get(i)) >=
                  Integer.parseInt(temp_values.get(i + 1))) ||
                  (direction.equals("GT") &&
                  Integer.parseInt(temp_values.get(i)) <=
                  Integer.parseInt(temp_values.get(i + 1))) ||
                  (direction.equals("EQ") &&
                  Integer.parseInt(temp_values.get(i)) !=
                  Integer.parseInt(temp_values.get(i + 1))) ||
                  (direction.equals("NE") &&
                  Integer.parseInt(temp_values.get(i)) ==
                  Integer.parseInt(temp_values.get(i + 1)))) {
                System.err.println(
                    "In period " + app.toString() +
                    " [" + c.getName() +
                    "] transition violation: previous value " +
                    result_nodes.get(i) + " and later value " +
                    result_nodes.get(i + 1) +
                    " violate the constraint [prev (" +
                    ((TransitionConstraint)c).getDirection() + ") later]");
                return false;
              }
            }
          }
        } else if (((TransitionConstraint)c).getMode() ==
                     TransitionConstraint.VALUEPAIR) {
          TreeSet<String> vp_set = ((TransitionConstraint)c).getValuePairSet();
          Set<String> key_set = value_map.keySet();
          for (String key : key_set) {
            Vector<String> temp_values = value_map.get(key);
            for (int i = 0; i < temp_values.size() - 1; ++i) {
              String old_val = temp_values.get(i);
              String new_val = temp_values.get(i + 1);
              if (!vp_set.contains(old_val + "-" + new_val)) {
                System.err.println(
                    "In period " + app.toString() +
                    " [" + c.getName() +
                    "] transition violation: value transition from " +
                    old_val + " to " + new_val + " is not allowed.");
                return false;
              }
            }
          }
        }
      }
    }
    return true;
  }
}
