package cs.arizona.tau.xml.temporalconstraint;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import javax.xml.XMLConstants;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import cs.arizona.util.ConventionalParser;

class NodePair {
  public Node parent_;
  public Node child_;
}

public class SliceValidator {

  SliceValidator(Node temporal_document) {
    temporal_document_ = temporal_document;
    //node_map_ = new HashMap<Integer, Node>();
  }
  
  
  public boolean SliceNValidate(String conventional_schema, Set<String> all_times) {
    Element temporal_root = (Element)temporal_document_;
    NodeList nl = temporal_root.getChildNodes();
    Node root = null;
    for (int i = 0; i < nl.getLength(); ++i) {
      Node tmp_node = nl.item(i);
      if (tmp_node.getNodeType() == Node.ELEMENT_NODE &&
          !tmp_node.getNodeName().equals("temporalSchemaSet")) {
        root = tmp_node;
      }
    }
    long val_st = 0;
    long val_time = 0;
    try {
      SchemaFactory factory = SchemaFactory.newInstance(
          XMLConstants.W3C_XML_SCHEMA_NS_URI);
      Schema schema = factory.newSchema(new StreamSource(conventional_schema));
      Validator validator = schema.newValidator();
      validator.setErrorHandler(new MyErrorHandler());
      for (String current_time : all_times) {
        Node slice_root = null;
        slice_root = WalkTree(root, slice_root, current_time);
//        ConventionalParser.getInstance().writeElement(
//            (Element)slice_root, "/tmp/temp_doc_" + current_time + ".xml");
        //val_st = System.currentTimeMillis();
        validator.validate(new DOMSource(slice_root));
        //val_time += System.currentTimeMillis() - val_st;
      }
      //System.out.println("clone called time: " + called_ + " total time: " + clone_time_ + " validation time: " + val_time);
    } catch (Exception ex) {
      ex.printStackTrace();
      System.err.println(ex.getMessage());
      return false;
    }
    return true;
  }
  
  
  public Node WalkTree(Node current_node, Node target_node,
                       String current_time) {
    if (current_node.getNodeName().contains("_RepItem")) {
      NodeList node_versions = current_node.getChildNodes();
      for (int i = 0 ; i < node_versions.getLength(); ++i) {
        Node tmp_node = node_versions.item(i);
        if (tmp_node.getNodeName().contains("_Version")) {
          target_node = WalkTree(tmp_node, target_node, current_time);
        }
      }
      return target_node;
    }
    if (current_node.getNodeName().contains("_Version")) {
      String st = ((Element)current_node).getAttribute("begin");
      String et = ((Element)current_node).getAttribute("end");
      if (st.compareTo(current_time) < 0 && et.compareTo(current_time) >= 0) {
        NodeList child_nodes = current_node.getChildNodes();
        for (int i = 0; i < child_nodes.getLength(); ++i) {
          Node tmp_node = child_nodes.item(i);
          if (tmp_node.getNodeType() == Node.ELEMENT_NODE) {
            target_node = WalkTree(tmp_node, target_node, current_time);
          }
        }
      }
      return target_node;
    }
    Node temp_node = null;
    if (target_node == null) {
      //st_ = System.currentTimeMillis();
      target_node = current_node.cloneNode(false); // clone?
      //clone_time_ += System.currentTimeMillis() - st_;
      //++called_;
      temp_node = target_node;
    } else {
    	temp_node = target_node;
    	//st_ = System.currentTimeMillis();
    	Node new_node = current_node.cloneNode(false);
    	//clone_time_ += System.currentTimeMillis() - st_;
    	//++called_;
      target_node.appendChild(new_node); // clone?
      target_node = new_node;
    }
    NodeList child_nodes = current_node.getChildNodes();
    if (child_nodes != null && child_nodes.getLength() > 0) {
      for (int i = 0; i < child_nodes.getLength(); ++i) {
        Node tmp_node = child_nodes.item(i);
        target_node = WalkTree(tmp_node, target_node, current_time);
      }
    }
    target_node = temp_node;
    return target_node;
  }
  
  private Node temporal_document_;
  //private Map<Integer, Node> node_map_;
  public int called_ = 0;
  public long clone_time_ = 0;
  public long st_;
}
