package cs.arizona.tau.xml.temporalconstraint;

import static org.junit.Assert.*;

import java.util.Vector;

import junit.framework.Assert;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.Document;

import cs.arizona.util.ConventionalParser;

public class ReferentialIntegrityConstraintTest {
  Document temporal_doc_;
  Document annotation_doc_;
  Document schema_doc_;
  Applicability default_applicability_;
  Vector<Constraint> constraints_;
  TemporalConstraintValidator tcv_;
  
  @BeforeClass
  public static void setUpBeforeClass() throws Exception {
  }

  @AfterClass
  public static void tearDownAfterClass() throws Exception {
  }

	@Before
  public void setUp() throws Exception {
    constraints_ = new Vector<Constraint>();
    String temporalSchema =
        "test_suites/ts_referential.xml";
    Document input_temporal_doc =
  	  ConventionalParser.getInstance().parseDocument(
            "test_suites/output.final.xml", null, null, false);
    tcv_ = new TemporalConstraintValidator(
        input_temporal_doc, temporalSchema);
    temporal_doc_ = tcv_.GetTemporalDocument();
    annotation_doc_ = tcv_.GetAnnotationDocument();
    schema_doc_ = tcv_.GetSchemaDocument();
    tcv_.ExtractConstraints(
        annotation_doc_.getDocumentElement(), "nonSeqKeyref",
        constraints_);
  }

  @After
  public void tearDown() throws Exception {
  }

  @Test
  public void testCheckNonSeqKeyRef() {
    int num_constraints = constraints_.size();
    Assert.assertEquals(1, num_constraints);
    Vector<Constraint> constraint1 = new Vector<Constraint>();
    constraint1.add(constraints_.get(0));
    boolean val1 = ReferentialIntegrityConstraint.CheckNonSeqKeyRef(
        temporal_doc_, schema_doc_, constraint1);
    Assert.assertTrue(val1);
    /*
    Vector<Constraint> constraint2 = new Vector<Constraint>();
    constraint2.add(constraints_.get(1));
    boolean val2 = ReferentialIntegrityConstraint.CheckNonSeqKeyRef(
        temporal_doc_, schema_doc_, constraint2);
    Assert.assertFalse(val2);
    */
  }
}
