package cs.arizona.tau.xml.temporalconstraint;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;

import org.w3c.dom.Document;
import org.w3c.dom.Node;

import cs.arizona.tau.xml.TXSchemaConstants;

/**
 * The <code>IdentityConstraint</code> sub-class extending
 * <code>Constraint</code>
 * @author ruizhang
 *
 */
public class IdentityConstraint extends Constraint {
  protected String scope_ = "between";
  protected String conventional_identifier_ = null;
  protected int null_count_min_ = -1;
  protected int null_count_max_ = -1;
  
  /**
   * Constructing the <code>IndentyConstraint</code> instance with its
   * specific attributes, which are <code>scope</code>,
   * <code>conventional_identifier</code>,
   * <code>null_count_min</code> and <code>null_count_max</code>.
   * @param name
   * @param dimension
   * @param selector
   * @param field
   * @param evaluation_window
   * @param slide_size
   * @param applicability
   * @param scope
   * @param conventional_identifier
   * @param null_count_min
   * @param null_count_max
   */
  public IdentityConstraint(String name, String item_target,
		                    String item_identifier,
                            String dimension, String selector,
                            String field, int evaluation_window,
                            int slide_size, Applicability applicability,
                            String scope, String conventional_identifier,
                            int null_count_min, int null_count_max) {
    super(name, item_target, item_identifier,
          dimension, selector, field, evaluation_window, slide_size,
          applicability);
    if (scope != null && !scope.equals("")) {
      scope_ = scope;
    }
    conventional_identifier_ = conventional_identifier;
    null_count_min_ = null_count_min;
    null_count_max_ = null_count_max;
  }
    
    
  public String getScope() {
    return scope_;
  }
  
  
  public int getNullCountMin() {
    return null_count_min_;
  }
  
  
  public int getNullCountMax() {
    return null_count_max_;
  }
  
  
  /**
   * Checking constraint 6.1 (1) the <code>NonSeqUnique</code> constraint
   * @param temporal_doc the temporal document
   * @param constraints the list of defined <code>NonSeqUnique</code>
   * constraints
   */
  public static boolean CheckNonSeqUnique(Document temporal_doc,
                                          Vector<Constraint> constraints) {
    if (constraints == null) {
      return true;
    }
    for (Constraint c : constraints) {
      for (Applicability app : c.eval_windows_) {
          String xpath_query = TemporalConstraintValidator.PrepareXPathString(
              c.getSelector(), c.getField());
        //xpath_query += "|" +  c.getItemIdentifier();
        Vector<String> result_nodes =
            TemporalConstraintValidator.GetCandidateNodes(
                temporal_doc, xpath_query,
                c.getItemTarget(),
                c.getItemIdentifier(), app);
        if (result_nodes == null) {
          return false;
        }
        if (((IdentityConstraint)c).scope_.equals("between")) {
          Map<String, Set<String>> value_map =
              new HashMap<String, Set<String>>();
          for (String temp_node : result_nodes) {
            String[] key_value = temp_node.split(TXSchemaConstants.DELIMITER);
            if (value_map.containsKey(key_value[1])) {
              Set<String> temp_values = value_map.get(key_value[1]);
              // if a different identifier appears with the same unique value 
              if (temp_values.add(key_value[0])) {
                System.err.println(
                    "In period " + app.toString() +
                    " [" + c.getName() + "] violation of nonSeqUnique " +
                    "(scope=between) duplicated values in node: " +
                    key_value[0] + " - " + key_value[1]);
                return false;	  
              }
            } else {
              Set<String> cand_values = new TreeSet<String>();
              cand_values.add(key_value[0]);
              value_map.put(key_value[1], cand_values);
            }
          }
        } else if (((IdentityConstraint)c).scope_.equals("within")) {
          Map<String, Set<String>> value_map =
              new HashMap<String, Set<String>>();
          for (String temp_node : result_nodes) {
            String[] key_value = temp_node.split(TXSchemaConstants.DELIMITER);
            if (value_map.containsKey(key_value[0])) {
              Set<String> temp_values = value_map.get(key_value[0]);
              // if the same identifier sees another value
              if (!temp_values.add(key_value[1])) {
                System.err.println(
                        "In period " + app.toString() +
                        " [" + c.getName() + "] violation of nonSeqUnique" +
                        "(scope=within) with identifier -- values: " +
                        key_value[0] + " - " + key_value[1]);
                return false;	  
              }
            } else {
              Set<String> cand_values = new TreeSet<String>();
              cand_values.add(key_value[1]);
              value_map.put(key_value[0], cand_values);
            }
          }
        }
      }
    }
    return true;
  }
  
  
  /**
   * Checking constraint 6.1 (2) the <code>NonSeqKey</code> constraint
   * @param temporal_doc the temporal document
   * @param constraints the list of defined <code>NonSeqKey</code>
   * constraints
   */
  public static boolean CheckNonSeqKey(Document temporal_doc,
                                       Vector<Constraint> constraints) {
    if (constraints == null) {
      return true;
    }
    for (Constraint c : constraints) {
      for (Applicability app : c.eval_windows_) {
        String xpath_query = TemporalConstraintValidator.PrepareXPathString(
    	    c.getSelector(), c.getField());
        //xpath_query += "|" +  c.getItemIdentifier();
        Vector<String> result_nodes =
            TemporalConstraintValidator.GetCandidateNodes(
                temporal_doc, xpath_query,
                c.getItemTarget(),
                c.getItemIdentifier(), app);
        if (result_nodes == null) {
          return false;
        }
        if (((IdentityConstraint)c).scope_.equals("between")) {
          Map<String, Set<String>> value_map =
              new HashMap<String, Set<String>>();
          for (String temp_node : result_nodes) {
            String[] key_value = temp_node.split(TXSchemaConstants.DELIMITER);
            if (key_value[0].equals("")) {
              System.err.println(
                  "In period " + app.toString() +
                  " [" + c.getName() + "] null value for KEY found.");
              return false;
            }
            if (value_map.containsKey(key_value[1])) {
              Set<String> temp_values = value_map.get(key_value[1]);
              // if a different identifier appears with the same unique value 
              if (temp_values.add(key_value[0])) {
                System.err.println(
                    "In period " + app.toString() +
                    " [" + c.getName() + "] violation of nonSeqKey " +
                    "(scope=between) duplicated values in node: " +
                    key_value[0] + " - " + key_value[1]);
                return false;	  
              }
            } else {
              Set<String> cand_values = new TreeSet<String>();
              cand_values.add(key_value[0]);
              value_map.put(key_value[1], cand_values);
            }
          }
        } else if (((IdentityConstraint)c).scope_.equals("within")) {
          Map<String, Set<String>> value_map =
              new HashMap<String, Set<String>>();
          for (String temp_node : result_nodes) {
            String[] key_value = temp_node.split(TXSchemaConstants.DELIMITER);
            if (value_map.containsKey(key_value[0])) {
              Set<String> temp_values = value_map.get(key_value[0]);
              // if the same identifier sees another value
              if (!temp_values.add(key_value[1])) {
                System.err.println(
                    "In period " + app.toString() +
                    " [" + c.getName() + "] violation of nonSeqKey" +
                    "(scope=within) with identifier -- values: " +
                    key_value[0] + " - " + key_value[1]);
                return false;	  
              }
            } else {
              Set<String> cand_values = new TreeSet<String>();
              cand_values.add(key_value[1]);
              value_map.put(key_value[0], cand_values);
            }
          }
        }
      }
    }
    return true;
  }
  
  
  /**
   * Checking constraint 6.1 (3) the <code>UniqueNullRestricted</code>
   * constraint
   * @param temporal_doc the temporal document
   * @param constraints the list of defined <code>UniqueNullRestricted</code>
   * constraints
   */
  public static boolean CheckUniqueNullRestricted(
      Document temporal_doc, Vector<Constraint> constraints) {
    if (constraints == null) {
      return true;
    }
    for (Constraint c : constraints) {
      int min_null = ((IdentityConstraint)c).getNullCountMin();
      int max_null = ((IdentityConstraint)c).getNullCountMax();
      if (min_null == -1 && max_null == -1) {
        return true;
      }
      for (Applicability app : c.eval_windows_) {
        String xpath_query = TemporalConstraintValidator.PrepareXPathString(
    	    c.getSelector(), c.getField());
        //xpath_query += "|" +  c.getItemIdentifier();
        Vector<String> result_nodes =
            TemporalConstraintValidator.GetCandidateNodes(
                temporal_doc, xpath_query,
                c.getItemTarget(),
                c.getItemIdentifier(), app);
        if (result_nodes == null) {
          return false;
        }
        int null_count = 0;
        for (String n : result_nodes) {
          // how to correctly represent null?
          if (n.equals("null")) {
            ++null_count;
          }
        }
        if (min_null != -1 && null_count < min_null) {
          System.err.println(
              "In period " + app.toString() +
              " [" + c.getName() + "] violation of min null value allowed: " +
              "actual = " + null_count + " min = " + min_null);
          return false;
        }
        if (max_null != -1 && null_count > max_null) {
          System.err.println(
              "In period " + app.toString() +
              " [" + c.getName() + "] violation of max null value allowed: " +
              "actual = " + null_count + " max = " + max_null);
          return false;
        }
      }
    }
    return true;
  }
  
  /*
  public static boolean CheckSeqIdentity(Document temporal_doc,
                                         Vector<Constraint> constraints) {
    if (constraints == null) {
      return true;
    }
    for (Constraint c : constraints) {
      for (Applicability app : c.eval_windows_) {
        String xpath_query = TemporalConstraintValidator.PrepareXPathString(
            c.getSelector(), c.getField());
        Vector<String> result_nodes =
            TemporalConstraintValidator.GetCandidateNodes(
                temporal_doc, xpath_query,
                c.getItemTarget(),
                c.getItemIdentifier(), app);
        if (result_nodes == null) {
          return false;
        }
        Map<String, Set<String>> value_map =
            new HashMap<String, Set<String>>();
        for (String temp_node : result_nodes) {
          String[] key_value = temp_node.split(TXSchemaConstants.DELIMITER);
          if (key_value[0].equals("")) {
            System.err.println(
                "In period " + app.toString() +
                    " [" + c.getName() + "] null value for KEY found.");
            return false;
          }
          if (value_map.containsKey(key_value[0])) {
            Set<String> temp_values = value_map.get(key_value[0]);
            if (temp_values.add(key_value[1])) {
              System.err.println(
                  "In period " + app.toString() +
                  " [" + c.getName() + "] violation of SeqKey " +
                  " duplicated values in node: " +
                  key_value[0] + " - " + key_value[1]);
              return false;
            }
          } else {
            Set<String> cand_values = new TreeSet<String>();
            cand_values.add(key_value[1]);
            value_map.put(key_value[0], cand_values);
          }
        }
      }
    }
    return true;
  }
  */
}
