package cs.arizona.tau.xml.temporalconstraint;

/**
 * Applicability as a time period
 * @author ruizhang
 *
 */
public class Applicability {
  private String start_time_ = null;
  private String end_time_ = null;

  /**
   * Constructing the applicability instance
   * @param start_time starting time
   * @param end_time ending time
   */
  public Applicability(String start_time, String end_time) {
    start_time_ = start_time;
    end_time_ = end_time;
  }
  
  
  /**
   * @return the start time of the applicability
   */
  public String GetStartTime() {
    return start_time_;
  }
  
  
  /**
   * 
   * @return the end time of the applicability
   */
  public String GetEndTime() {
    return end_time_;
  }
  
  
  /**
   * Checking if the period of this applicability intersects with
   * another one. 
   * @param st start time
   * @param et end time
   * @return <code>TRUE</code> if intersects, <code>FALSE</code> otherwise.
   */
  public boolean IsIntersect(String st, String et) {
    if ((Applicability.CompareTime(start_time_, st) == 0 ||
         Applicability.CompareTime(end_time_, et) == 0) ||
        (Applicability.CompareTime(start_time_, st) > 0 &&
         Applicability.CompareTime(start_time_, et) < 0) ||
        (Applicability.CompareTime(end_time_, st) > 0 &&
         Applicability.CompareTime(end_time_, et) < 0) ||
        (Applicability.CompareTime(st, start_time_) > 0 &&
         Applicability.CompareTime(st, end_time_) < 0) || 
        (Applicability.CompareTime(et, start_time_) > 0 &&
         Applicability.CompareTime(et, end_time_) < 0)) {
      return true;
    } else {
      return false;
    }
  }

  
  public String toString() {
    return "[" + start_time_ + " - " + end_time_ + "]"; 
  }
  
  
  /**
   * Comparing two time periods and determining the order 
   * @param t1 Time period 1
   * @param t2 Time period 2
   * @return negative if <code>t1 < t2</code>; positive if
   * <code>t1 > t2</code>; 0 otherwise
   */
  static public int CompareTime(String t1, String t2) {
    String[] tok1 = t1.split("-");
    int year1 = Integer.parseInt(tok1[0]);
    int month1 = Integer.parseInt(tok1[1]);
    int day1 = Integer.parseInt(tok1[2]);

    String[] tok2 = t2.split("-");
    int year2 = Integer.parseInt(tok2[0]);
    int month2 = Integer.parseInt(tok2[1]);
    int day2 = Integer.parseInt(tok2[2]);

    if (year1 < year2) {
      return -1;
    } else if (year1 > year2) {
      return 1;
    } else {
      // years are equal
      if (month1 < month2) {
        return -2;
      } else if (month1 > month2) {
        return 2;
      } else {
        // months are equal
        if (day1 < day2) {
          return -3;
        } else if (day1 > day2) {
         return 3;
        } else {
          return 0;
        }
      }
    }
  }
  
  
  /**
   * Given a start time stamp, computing the end time stamp
   * according to the length of the period
   * @param begin start time stamp
   * @param gap length of the period (number of days)
   * @return the end time stamp
   */
  public static String GetPeriodBound(String begin, int gap) {
    String time_detail[] = begin.split("-");
    int year = Integer.parseInt(time_detail[0]);
    int month = Integer.parseInt(time_detail[1]);
    int day = Integer.parseInt(time_detail[2]);
    day += gap;
    while (true) {
      switch (month) {
      case 1:
      case 3:
      case 5:
      case 7:
      case 8:
      case 10:
      case 12:
        if (day > 31) {
          if (month == 12) {
            month = 1;
            ++year;
          } else {
            ++month;
          }
          day -= 31;
        } else {
          return year + "-" + month + "-" + day;
        }
        break;
      case 4:
      case 6:
      case 9:
      case 11:
        if (day > 30) {
          ++month;
          day -= 30;
        } else {
          return year + "-" + month + "-" + day;
        }
        break;
      case 2:
        if (year % 4 == 0) {
          if (day > 29) {
            ++month;
        day -= 29;
      } else {
            return year + "-" + month + "-" + day;
      }
        } else {
          if (day > 28) {
            ++month;
            day -= 28;
      } else {
            return year + "-" + month + "-" + day;
      }
        }
    break;
      }
    }
  }
}