/**
 * 
 */
package cs.arizona.tau.xml;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Iterator;

import org.w3c.dom.*;

import cs.arizona.util.SchemaPathEvaluator;
import cs.arizona.util.TargetIdentifier;
import cs.arizona.util.TauLogger;

/**
 * @author spjoshi
 * TODO : 
 * 1) Exception handling.
 * 2) Need to verify whether function createItemPrototypes handles all the conditions. 
 * 
 */
public class TemporalAnnotationValidator extends GenericValidator implements
		ITemporalAnnotationValidator {

	private Document snapshotSchemaDocument;
	private Document temporalAnnotationDocument;
	private TargetIdentifier ti;
	private ArrayList<String> targets 			= new ArrayList<String>();
	private Hashtable<String, Item> itemPrototypes 	= new Hashtable<String, Item>();
	private Hashtable<String, Integer> itemCounters		= new Hashtable<String, Integer>();
	
	/**
	 * 
	 */
	public TemporalAnnotationValidator(String temporalAnnotation, String snapshotSchema, boolean createItemPrototypes) {
		super();
		init();
		temporalAnnotationDocument = cp.parseDocument(temporalAnnotation, vp.getProperty("TXSchemaURL"), vp.getProperty("TXSchema"));
		snapshotSchemaDocument = cp.parseDocument(snapshotSchema, vp.getProperty("XMLSchemaURL"), vp.getProperty("XMLSchema"));
		this.ti = new TargetIdentifier(snapshotSchemaDocument);
		collectTargets();
		if (createItemPrototypes == true){
			createItemPrototypes();
		}
	}
	
	public TemporalAnnotationValidator(Document temporalAnnotationDocument, Document snapshotSchemaDocument, TargetIdentifier ti, boolean createItemPrototypes) {
		super();
		this.snapshotSchemaDocument = snapshotSchemaDocument;
		this.temporalAnnotationDocument = temporalAnnotationDocument;
		this.ti=ti;
		collectTargets();
		if (createItemPrototypes == true){
			createItemPrototypes();
		}
	}

	/* (non-Javadoc)
	 * @see cs.arizona.tau.xml.ITemporalAnnotationValidator#validateTemporalAnnotation(java.lang.String, java.lang.String)
	 */
	public boolean validateTemporalAnnotation() {
		return checkConsistency();
	}	

	/**
	 * The function returns the name of topmost element which has been timestamped in Temporal Annotation.
	 * @return
	 */
	public String getTopTarget(){
		String str = (String)targets.get(0);
		String prevSubStr = "", subStr="";
		StringTokenizer st = new StringTokenizer(str,"/");
		while(st.hasMoreTokens()){
			prevSubStr = subStr;
			subStr = subStr + "/" + st.nextToken();
			Iterator itr = targets.iterator();
			while (itr.hasNext()){
				if (!(((String)itr.next()).startsWith(subStr))){
					break;
				}
			}
		}
		return prevSubStr;
	}

	/**
	 * Checking whether every target given in the temporal annotation is present in the snapshot schema or not.
	 * TODO: Also need to check that the temp annotation is below a physical annotation.
	 * @return
	 */
	private boolean checkConsistency(){
		//Get the list of all the elements with attribute
		Element targetElement;
		NodeList itemList = temporalAnnotationDocument.getElementsByTagName("item"); 
		for (int i=0 ; i<itemList.getLength() ; i++){
			Element itemElement = (Element)itemList.item(i);
			String target = itemElement.getAttribute("target");
			if ((targetElement=validateTarget(target))==null){
				TauLogger.logger.error("Could not validate temporal annotation on \"" + target + "\"");
				return false;
			}
			/* NOT CURRENTLY WORKING: Validate field not expecting input being given
			NodeList fieldList = itemElement.getElementsByTagName("field");
			for (int j=0 ; j<fieldList.getLength() ; j++){
				String fieldTarget = ((Element)fieldList.item(j)).getAttribute("path");
				if (validateField(targetElement,fieldTarget)==false){
					TauLogger.logger.error("Could not validate temporal annotation on field path \"" + fieldTarget + "\"");
					return false;
				}
			}
			*/
		}
		TauLogger.logger.info("Temporal Annotations validated successfully.");
		return true;
	}
	
	
	private Element validateTarget(String target){
		Element r = ti.getTarget(target);
		if (r == null){
			TauLogger.logger.error("Target Identifier does not have target \"" + target + "\".");
		}
		return r;
	}
	
	private boolean validateField(Element element, String fieldPath){
		return ti.validateField(element,fieldPath);
	}
	
	private void collectTargets(){
		Element root = temporalAnnotationDocument.getDocumentElement();
		NodeList nl=root.getChildNodes();
		for (int i=0 ; i<nl.getLength(); i++){
			if (nl.item(i).getNodeType() == Node.ELEMENT_NODE){
				Element currentElement = (Element)nl.item(i);
				if (currentElement.getLocalName() == "item"){
					targets.add(currentElement.getAttribute("target"));
				}
			}
		}
	}
	
	public boolean containsTarget(String target){
		if (targets.contains(target)){
			return true;
		}else{
			return false;
		}
	}

	/**
	 * The function creates the item prototypes for all the items from temporal annotation. 
	 *
	 */
	public void createItemPrototypes(){
		Element root = temporalAnnotationDocument.getDocumentElement();
		NodeList nl=root.getChildNodes();
		for (int i=0 ; i<nl.getLength(); i++){
			if (nl.item(i).getNodeType() == Node.ELEMENT_NODE){
				Element currentElement = (Element)nl.item(i);
				if (currentElement.getLocalName() == "item"){
					Item item = new Item(currentElement);
					itemPrototypes.put(currentElement.getAttribute("target"),item);
				}
			}
		}
	}
	
	public void resetItemCounters(){
		Element root = temporalAnnotationDocument.getDocumentElement();
		NodeList nl=root.getChildNodes();
		for (int i=0 ; i<nl.getLength(); i++){
			if (nl.item(i).getNodeType() == Node.ELEMENT_NODE){
				Element currentElement = (Element)nl.item(i);
				if (currentElement.getLocalName() == "item"){
					itemCounters.put(currentElement.getAttribute("target"),new Integer(0));
				}
			}
		}
	}

	// sthomas- return null if not found.
	public Item getItemPrototype(String target){
		Item o = ((Item)itemPrototypes.get(target));
		if (o != null){
			return o.cloneItem();
		}
		return null;
	}
	
	public String getNextItemID(String target){
		int currCounter = ((Integer)itemCounters.get(target)).intValue() +1 ;
		itemCounters.put(target,new Integer(currCounter));
		return target.replace('/','_') + String.valueOf(currCounter);
	}

	public Iterator getTargetIterator(){
		return targets.iterator();
	}
}
