package cs.arizona.tau.xml;

import cs.arizona.util.ConventionalParser;
import cs.arizona.util.TauLogger;
import org.apache.log4j.Level;


import org.w3c.dom.*;

public class Squash {


	public static void main(String[] args) {

	    long t1 = System.nanoTime();
	    
		// Debug output - Default to FATAL messages only
		TauLogger.init();
		TauLogger.setLevel(1);
	    
		/* Parse command line args */
		if (args.length < 1){
			System.out.println("usage: squash [-o outputFile] [-s schemaVersFlag] [-d debugLevel] temporal_file");
			System.exit(1);
		}
	    

		//String tempDataDir = args[args.length - 2];
		String file_path = args[args.length - 1];
		String tempDataDir = ".";
		String tempDataFile = file_path;
		if (file_path.contains("/")) {
          int dir_separator_index = file_path.lastIndexOf("/");
          tempDataDir = file_path.substring(0, dir_separator_index);
		  tempDataFile = file_path.substring(dir_separator_index + 1,
              file_path.length());
		}
		Common.checkFileExists(file_path);
		
		String outName = tempDataFile.substring(0, tempDataFile.indexOf(".xml")) + "_squashed.xml";
		boolean schemaVersioningFlag = false;

		for (int i = 0; i < args.length; ++i){
			
			if (args[i].equals("-o")){
				outName = args[i+1];
				++i;
			} else if (args[i].equals("-s")){
				schemaVersioningFlag = Boolean.parseBoolean(args[i+1]);
				++i;
			}
			else if (args[i].equals("-d")){
				TauLogger.setLevel(Integer.parseInt(args[i+1]));
				++i;
			}
		}
		
		TauLogger.logger.info("Squashing documents (schemaVersioningFlag = " + schemaVersioningFlag + ")...");
		
		IRepresentationFactory iRepFactory = new DecomposedRepresentationFactory();
		IDoSquashing doSquashing = iRepFactory.createSquashingObj(tempDataDir, tempDataFile, schemaVersioningFlag);
		
		doSquashing.setOutputFileName(tempDataDir, outName);
		doSquashing.squash(tempDataDir, tempDataFile);
		
		// Debug output
		TauLogger.logger.info("Done.");		

        
	    long t2 = System.nanoTime();
		Common.printElaspedTime("Squash", t1, t2);
	}
	
}
