/**
 * @author Shailesh Joshi
 *
 */

package cs.arizona.tau.xml;

import org.w3c.dom.*;

import java.util.Hashtable;
import java.util.Enumeration;
import java.util.Date;

import cs.arizona.tau.time.*;

import cs.arizona.util.*;
/**
 * @author spjoshi
 *
 */
public class SchemaStub {
	
	private static ConventionalParser cp;
	private static ValidatorProperties vp;
	
	/**
	 * @param args0
	 */
	public static void main(String[] args) {
		init();
		//stubDataVersionGenerator();
		//stubSchemaSchemaMappnig();
		//stubSchemaSquashing();
		//stubSchemaUnSquashing();
		
		//Rui Commented out this
		//stubTemporalValidator();
	}
	
	/**
	 *	DataStub for DoDataSchemaMapping
	 */
	private static void stubSchemaSchemaMappnig(){
        String temporalBundle = "D:/EclipseWorkspace/TXSchema/test_cases/schema_versioning/SchemaMapper/testcase1/winolympic_bundle.xml";
        String repSchema = "D:/EclipseWorkspace/TXSchema/test_cases/schema_versioning/SchemaMapper/testcase1/winolympic_rep.xsd";
        Document repSchemaDoc;
        DoSVSchemaMapping doSVSchemaMapping = new DoSVSchemaMapping();
        repSchemaDoc = doSVSchemaMapping.createRepresentationalSchema(temporalBundle);
		cp.writeDocument(repSchemaDoc, repSchema);
		cp.parseDocument(repSchema, null, vp.getProperty("XMLSchema"));
	}
	
	private static void init(){
		cp = ConventionalParser.getInstance();
		vp = ValidatorProperties.getInstance();
	}
	
	private static void stubSchemaSquashing(){
		String temporalBundle;
		String temporalDocument;
		String configFile;
		String repSchema;
        Document temporalDoc, repSchemaDoc;

        temporalBundle = "D:/EclipseWorkspace/TXSchema/test_cases/schema_versioning/squash/testcase1/winolympic_bundle.xml";
        configFile = "D:/EclipseWorkspace/TXSchema/test_cases/schema_versioning/squash/testcase1/config.xml";
        temporalDocument = "D:/EclipseWorkspace/TXSchema/test_cases/schema_versioning/squash/testcase1/winolympic_tv.xml";
        repSchema = "D:/EclipseWorkspace/TXSchema/test_cases/schema_versioning/squash/testcase1/winolympic_rep.xsd";

        // this is my stuff!! Rui
        String tempDataDir = "/tmp";
        //cp.parseDocument(temporalDocument, null, null);
        
        DoSVSchemaMapping doSVSchemaMapping = new DoSVSchemaMapping();
        repSchemaDoc = doSVSchemaMapping.createRepresentationalSchema(temporalBundle);
		cp.writeDocument(repSchemaDoc, repSchema);

        DoSVSquashing doSVSquashing = new DoSVSquashing();
        temporalDoc = doSVSquashing.squash(tempDataDir, configFile);
		cp.writeDocument(temporalDoc, temporalDocument);
		cp.parseDocument(temporalDocument, null, repSchema);
	}
	
	private static void stubSchemaUnSquashing(){
		String temporalBundle;
		String temporalDocument;
		String configFile;
		String snapshotDate;

        temporalBundle = "D:/EclipseWorkspace/TXSchema/test_cases/schema_versioning/unsquash/testcase1/winolympic_bundle.xml";
		temporalDocument = "D:/EclipseWorkspace/TXSchema/test_cases/schema_versioning/unsquash/testcase1/winolympic_tv.xml";
        configFile = "D:/EclipseWorkspace/TXSchema/test_cases/schema_versioning/unsquash/testcase1/config.xml";
        snapshotDate = "2002-11-11";
        stubSchemaUnSquashing(temporalBundle, temporalDocument, configFile, snapshotDate);
	}
	
	private static void stubSchemaUnSquashing(String temporalBundle, String temporalDocument, String configFile, String snapshotDate){
		DoSVUnSquashing doUnSquashing;
		Hashtable snapshots;
		String configDir = temporalDocument.substring(0,temporalDocument.lastIndexOf("/")) + "/"; 
		String baseFileName = temporalDocument.substring(temporalDocument.lastIndexOf("/") + 1, temporalDocument.lastIndexOf(".xml"));
		
		// this is my stuff!! Rui
		String tempDataDir = "/tmp";
		
		//Testing for unSquash
		doUnSquashing = new DoSVUnSquashing();
		snapshots = doUnSquashing.unSquash(tempDataDir, temporalDocument);
		
		Enumeration enumeration = snapshots.keys();
		while (enumeration.hasMoreElements()){
			ITimePeriod tp = (ITimePeriod)enumeration.nextElement();
			Element e = (Element)snapshots.get(tp);
			Date beginDate = tp.getBeginDate();
			Date endDate = tp.getEndDate();
			String snapshotFile = configDir + baseFileName + "_" + beginDate.getYear() + "_" + beginDate.getMonth() + "_" + beginDate.getDate()
			+ "_" + endDate.getYear() + "_" + endDate.getMonth() + "_" + endDate.getDate() + ".xml";
			cp.writeElement(e, snapshotFile);
		}
		
		//Testing for getSnapshot
		String snapshotFile = configDir + "snapshot" + snapshotDate + ".xml";
		Document snapshotDoc = doUnSquashing.getSnapshot(temporalDocument, snapshotDate);
		cp.writeDocument(snapshotDoc, snapshotFile);
	}
	
	private static void stubTemporalValidator(String temp_data_dir){
		String temporalDocument;
		DoSVTemporalValidation doTemporalValidator;
		
		temporalDocument = "D:/EclipseWorkspace/TXSchema/test_cases/schema_versioning/temporalValidator/testcase1/winolympic_tv.xml";
		doTemporalValidator = new DoSVTemporalValidation();
		if (doTemporalValidator.validate(temp_data_dir, temporalDocument)){
			System.out.println("Validation Successful.");
		}else{
			System.out.println("Validation Failed.");
		}
	}
}
