/*
 * Created on Sep 13, 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package cs.arizona.tau.xml;


import java.text.SimpleDateFormat;
import java.util.Iterator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Document;

import java.util.ArrayList;

import cs.arizona.tau.time.ITimePeriod;
import cs.arizona.tau.time.TimePeriod;
import cs.arizona.tau.time.ITemporalRegion;
import cs.arizona.tau.time.TemporalRegion;
import cs.arizona.tau.time.ITime;
import cs.arizona.util.ConventionalParser;



/**
 * @author shailesh
 *
 * Representation of an Item. Item contains its ItemIdentifier and all of its versions. 
 * 
 */
public class RepItem extends BaseItem{

	/**
	 * Comment for <code>itemIdentifier</code>
	 */
	protected int timeRepresentation;

	/**
	 * 
	 */
	public RepItem() {
		super();
	}
	
	/**
	 * 
	 */
	public RepItem(RepItem repItem) {
		super(repItem);
		this.timeRepresentation = repItem.timeRepresentation;
	}

	/**
	 * 
	 */
	public RepItem(String target,int timeDimension, int timeRepresentation ) {
		super();
		this.target = target ;
		this.timeDimension = timeDimension;
		this.timeRepresentation = timeRepresentation ;
		this.temporalElement.setNumDimensions(timeDimension);
	}
	
	public String toString(){
		return super.toString();
	}
	
	/**
	 * The constructor accepts the element declaration from physical annotation and creates corresponding repItem. 
	 * There are no versions present in such RepItem.  
	 * @param e 
	 */
	public RepItem(Element xmlRepItemSchemaElement){
		this.target = xmlRepItemSchemaElement.getAttribute("target");
		NodeList nl1 = xmlRepItemSchemaElement.getChildNodes();
		for (int i=0 ; i < nl1.getLength() ; i++){
			if (nl1.item(i).getNodeType() == Node.ELEMENT_NODE){
				Element childElement=(Element)nl1.item(i);
				if (childElement.getLocalName() == "stampKind"){
					this.timeDimension = (childElement.getAttribute("timeDimension")=="valid")?ITimePeriod.VALID_TIME :((childElement.getAttribute("timeDimension")=="transaction")?ITimePeriod.TRANSACTION_TIME :ITimePeriod.BITEMPORAL_TIME);
					this.timeRepresentation = (childElement.getAttribute("stampBounds")=="stamp")?ITimePeriod.EXTENT_REP : ITimePeriod.STEP_REP;
				}
			}
		}
	}
	
	/**
	 * Given a RepItem Element from temporal document, creates corresponding RepItem for that element.
	 * @param repItemElement
	 * @param target
	 */
	public RepItem(Node repItemElement,String target){
		this.target=target;
		NodeList nl = repItemElement.getChildNodes();
		long time_tag = System.currentTimeMillis();
		for (int i=0 ; i<nl.getLength() ; i++){ 
			if (nl.item(i).getNodeType() == Node.ELEMENT_NODE){
				Element childElement = (Element)nl.item(i);
				addVersion(childElement);
			}
		}
		this.timeRepresentation = TimePeriod.EXTENT_REP;
	}

	/**
	 * @return Returns the timeDimension.
	 */
	public int getTimeDimension() {
		return timeDimension;
	}

	/**
	 * @param timeDimension The timeDimension to set.
	 */
	public void setTimeDimension(int timeDimension) {
		this.timeDimension = timeDimension;
	}

	/**
	 * @return Returns the timeRepresentation.
	 */
	public int getTimeRepresentation() {
		return timeRepresentation;
	}

	/**
	 * @param timeRepresentation The timeRepresentation to set.
	 */
	public void setTimeRepresentation(int timeRepresentation) {
		this.timeRepresentation = timeRepresentation;
	}
	
	/**
	 * Given a document, the function creates a <_RepItem>/<_item> element from given repItem and return it. 
	 * @param doc
	 * @return
	 */
	public Element toXML(Document doc, String repSchemaNameAlias){
		Element repItemElement = doc.createElement(repSchemaNameAlias + this.target + TXSchemaConstants.ITEM_SUFFIX);

		repItemElement.setAttribute("isItem","y");
		repItemElement.setAttribute("originalElement",this.target);
		
		/* For non-decomposed representation itemID is not required 
		repItemElement.setAttribute("itemID",this.itemID); */
		
		Iterator teIterator = temporalElement.iterator();
		Iterator versionsIterator = versions.iterator();
		while (versionsIterator.hasNext()){
			// Rui added the cloneNode part. Cloning solved the issue of missing child content
			Element currVersion = (Element)((Element)versionsIterator.next()).cloneNode(true);
			ITime time1 = (ITime)teIterator.next();
			repItemElement.appendChild(toXMLVersion(currVersion,time1,doc));
		}
		return repItemElement;
	}
	
	public void chopVersions(ITimePeriod tp){
		Iterator versionIterator = versions.iterator();
		Iterator teIterator = temporalElement.iterator();
		
		ArrayList versionsToRemove = new ArrayList();
		ArrayList timePeriodToRemove = new ArrayList();
		
		while ((teIterator.hasNext()) && (versionIterator.hasNext())){
			ITimePeriod tp1 = (ITimePeriod)teIterator.next();
			Element version = (Element)versionIterator.next();
			int relationship =tp1.getRelationship(tp); 
			if ( relationship <= ITimePeriod.NO_OVERLAP){
				versionsToRemove.add(version);
				timePeriodToRemove.add(tp1);
			}else{
				switch(relationship){
				
				case ITimePeriod.A_OVERLAPS_B  : 	tp1.setBeginDate(tp.getBeginDate());
												 	break;
				case ITimePeriod.B_OVERLAPS_A  :	tp1.setEndDate(tp.getEndDate());
													break;
				case ITimePeriod.B_STARTS_A    :	tp1.setEndDate(tp.getEndDate());
													break;
				case ITimePeriod.B_FINISHES_A  :	tp1.setBeginDate(tp.getBeginDate());
			 										break;
				case ITimePeriod.B_DURING_A    :	tp1.setBeginDate(tp.getBeginDate());
													tp1.setEndDate(tp.getEndDate());
													break;
				}
			}
		}
		versionIterator = versionsToRemove.iterator();
		teIterator = timePeriodToRemove.iterator();
		while ((teIterator.hasNext()) && (versionIterator.hasNext())){
			versions.remove(versionIterator.next());
			temporalElement.remove((ITime)teIterator.next());
		}
	}
	
	/*
	 * Helper methods
	 */

	/**
	 * Given an XML element, the function returns whether that element corresponds to either VALID_TIME/TRANSACTION_TIME 
	 */
	/*
	private int getTimeDimensionFromXML(Element e){
		String name = e.getNodeName();
		name = name.substring(name.indexOf(':')+1);
		if (("timeStamp_TransExtent".equalsIgnoreCase(name)) || ("timeStamp_TransStep".equalsIgnoreCase(name))){
			return ITimePeriod.TRANSACTION_TIME;
		}else{
			if (("timeStamp_ValidExtent".equalsIgnoreCase(name)) || ("timeStamp_ValidStep".equalsIgnoreCase(name))){
				return ITimePeriod.VALID_TIME;
			}else{
				return 0;
			}
		}
	}
	*/
	// Rui's version
	private int getTimeDimensionFromXML(Element e){
		String name = e.getNodeName();
		name = name.substring(name.indexOf(':')+1);
		if (("timeStamp_TransExtent".equalsIgnoreCase(name)) || ("timeStamp_TransStep".equalsIgnoreCase(name))){
			return ITimePeriod.TRANSACTION_TIME;
		}else{
			if (("timeStamp_ValidExtent".equalsIgnoreCase(name)) || ("timeStamp_ValidStep".equalsIgnoreCase(name))){
				return ITimePeriod.VALID_TIME;
			}else{
				return 0;
			}
		}
	}
	
	/**
	 * The function extract information about original element and its corresponding TimePeriod/TemporalRegion
	 * and stores in TemporalElement and elementVersions ArrayList.
	 * @param xmlVersionElement
	 */
	private void addVersion(Element xmlVersionElement){
		NodeList nl = xmlVersionElement.getChildNodes();
		Element e = null;
		ITimePeriod validPeriod = null, transactionPeriod = null;
		// Rui added this since this is where to get the time period of the version item.
		// however, at this point, it is not clear where to grab the time period type.
	  if (!xmlVersionElement.getAttribute("begin").equals("") &&
          !xmlVersionElement.getAttribute("end").equals("")) {
		transactionPeriod = new TimePeriod(xmlVersionElement.getAttribute("begin"),
				                           xmlVersionElement.getAttribute("end"));
      }
		for (int i=0 ; i<nl.getLength() ; i++){
			if (nl.item(i).getNodeType() == Node.ELEMENT_NODE){
				Element currElement = (Element)nl.item(i);
				if (getTimeDimensionFromXML(currElement) == 0){
					e = currElement;
				}else{
					/*  Rui took this out since it's for the old version
					if (getTimeDimensionFromXML(currElement) == ITimePeriod.VALID_TIME){
						//validPeriod = new TimePeriod(currElement.getAttribute("begin"),currElement.getAttribute("end"));
						validPeriod = new TimePeriod(xmlVersionElement.getAttribute("begin"),xmlVersionElement.getAttribute("end"));
					}else{
						//transactionPeriod = new TimePeriod(currElement.getAttribute("begin"),currElement.getAttribute("end"));
						transactionPeriod = new TimePeriod(xmlVersionElement.getAttribute("begin"),xmlVersionElement.getAttribute("end"));
					}
					*/
				}
			}
		}
		//if (e == null) {
		//	System.err.println("e is null");
		//} else {
			// Rui warning: this could be wrong, may need to be restored by cancelling the null check
		  this.versions.add(e);
			
		//}
		if ((validPeriod != null) && (transactionPeriod != null)){
			ITemporalRegion tr = new TemporalRegion();
			temporalElement.add(tr);
			temporalElement.setNumDimensions(2);
			this.timeDimension = ITimePeriod.BITEMPORAL_TIME;
		}else{
			if (validPeriod != null){
				temporalElement.add(validPeriod);
				this.timeDimension = ITimePeriod.VALID_TIME;
				temporalElement.setNumDimensions(1);
			}else {// if (transactionPeriod != null){ //Rui added this condition check
				temporalElement.add(transactionPeriod);
				this.timeDimension = ITimePeriod.TRANSACTION_TIME;
				temporalElement.setNumDimensions(1);
			}
		}
	}
	
	/**
	 * Given XML Element, and an instance of TimePeriod/TemporalRegion creates a version element and returns it.
	 * @param e
	 * @param time1
	 * @param doc
	 * @return
	 */
	private Element toXMLVersion(Element e, ITime time1, Document doc){
		Element versionElement = doc.createElement(this.target + TXSchemaConstants.VERSION_SUFFIX);
		if ("cs.arizona.tau.time.TimePeriod".equals(time1.getClass().getName())){
			ITimePeriod tp = (TimePeriod)time1;
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
			versionElement.setAttribute("begin", sdf.format(tp.getBeginDate()));
			versionElement.setAttribute("end", sdf.format(tp.getEndDate()));
			//versionElement.appendChild(tp.toXML(this.timeDimension, this.timeRepresentation, doc));
		}else{
			ITemporalRegion tr = (TemporalRegion)time1;
			versionElement.appendChild(tr.getTransactionPeriod().toXML(ITimePeriod.TRANSACTION_TIME,this.timeRepresentation,doc));
			versionElement.appendChild(tr.getTransactionPeriod().toXML(ITimePeriod.VALID_TIME,this.timeRepresentation,doc));
		}
		// I (Rui) added this line!
		if (e != null) {
		  versionElement.appendChild(e);
		}
		return versionElement;
	}
}