/*
 * Created on Sep 13, 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package cs.arizona.tau.xml;


import java.util.Hashtable;
import java.util.Enumeration; 
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Node;
import org.w3c.dom.Document;
import org.w3c.dom.xpath.*;
import org.apache.xpath.domapi.XPathEvaluatorImpl; 

/**
 * @author shailesh
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class ItemIdentifier {

	public Hashtable fieldTable = new Hashtable();
	private String fieldValue;
	private String target;
	private String name;
	//private String[] itemRef;
	//private String[] keyRef;
	
	/**
	 * 
	 */
	public ItemIdentifier() {
		super();
		// TODO Auto-generated constructor stub
	}
	
	public String toString(){
		
		String result 
		        = "Field: " + fieldValue + "\n";
		result += "Target:" + target +"\n";
		result += "Name:  " + name;
		return result;
	}

	/**
	 * 
	 */
	public ItemIdentifier(Element e) {
		super();
		this.name = e.getAttribute("name");
		this.target = ((Element)e.getParentNode()).getAttribute("target");
		NodeList nl = e.getChildNodes();
		for (int i=0 ; i<nl.getLength() ; i++){
			if (nl.item(i).getNodeType() == Node.ELEMENT_NODE){
				Element currElement = (Element)nl.item(i);
				if (currElement.getLocalName() == "field"){
					if (currElement.getAttribute("path").endsWith("text")){
						this.fieldTable.put(currElement.getAttribute("path") + "()","");
					}else{
						this.fieldTable.put(currElement.getAttribute("path"),"");
					}
				}
			}
		}
		this.fieldValue = "";
	}
	
	/**
	 * @return Returns the fieldList.
	 */
	public Hashtable getFieldTable() {
		return fieldTable;
	}
	/**
	 * @param fieldList The fieldList to set.
	 */
	public void setFieldTable(Hashtable fieldTable) {
		this.fieldTable = fieldTable;
	}
	/**
	 * @return Returns the fieldValue.
	 */
	public String getFieldValue() {
		return fieldValue;
	}
	/**
	 * @param fieldValue The fieldValue to set.
	 */
	public void setFieldValue(String fieldValue) {
		this.fieldValue = fieldValue;
	}
	/**
	 * @return Returns the target.
	 */
	public String getTarget() {
		return target;
	}
	/**
	 * @param target The target to set.
	 */
	public void setTarget(String target) {
		this.target = target;
	}
	
	public boolean equals(ItemIdentifier ii){
		boolean flag = true;
		if (this.target.equals(ii.getTarget())){
			if (this.fieldValue.equals(ii.getFieldValue())){
				if (this.fieldTable.size() == ii.getFieldTable().size()){
					Enumeration enum1 = ii.getFieldTable().keys();
					while (enum1.hasMoreElements()){
						if (!(fieldTable.containsKey(enum1.nextElement()))){
							return false;
						}
					}
				}
			}else{
				return false;
			}
		}else{
			return false;
		}
		return flag;
	}

	public boolean equals(Object o){
		ItemIdentifier ii = (ItemIdentifier)o;
		boolean flag = true;
		if (this.target.equals(ii.getTarget())){
			if (this.fieldValue.equals(ii.getFieldValue())){
				if (this.fieldTable.size() == ii.getFieldTable().size()){
					Enumeration enum1 = ii.getFieldTable().keys();
					while (enum1.hasMoreElements()){
						if (!(fieldTable.containsKey(enum1.nextElement()))){
							return false;
						}
					}
				}
			}else{
				return false;
			}
		}else{
			return false;
		}
		return flag;
	}
	
	public int hashCode(){
		return name.hashCode() + target.hashCode() + fieldValue.hashCode();
	}
	/**
	 * @return Returns the name.
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param name The name to set.
	 */
	public void setName(String name) {
		this.name = name;
	}
	
	/**
	 * Given Element e, the function updates variable fieldValues and Hashtable fieldTable 
	 * @param e
	 */
	public void updateFieldValues(Element e,Document doc){
		//Initialize XPathEvaluator
		XPathEvaluator evaluator = new XPathEvaluatorImpl(doc);
		XPathNSResolver resolver = evaluator.createNSResolver(doc);
		Enumeration enum1 = fieldTable.keys();
		while (enum1.hasMoreElements()){
			String fieldPath = (String)enum1.nextElement();
			String tempFieldValue = "";
			if (fieldPath.endsWith("text")){
				fieldPath = fieldPath + "()";
				XPathResult result = (XPathResult)evaluator.evaluate(fieldPath,e,resolver,XPathResult.ORDERED_NODE_ITERATOR_TYPE,null);
				Node n;
				while ((n = result.iterateNext())!= null){
						tempFieldValue = tempFieldValue + n.getNodeValue();
				}
				fieldTable.put(fieldPath, tempFieldValue);
				fieldValue = fieldValue + tempFieldValue;
			}else{
				XPathResult result = (XPathResult)evaluator.evaluate(fieldPath,e,resolver,XPathResult.ORDERED_NODE_ITERATOR_TYPE,null);
				Node n;
				while ((n = result.iterateNext())!= null){
						fieldTable.put(fieldPath,n.getNodeValue());
						fieldValue = fieldValue + n.getNodeValue();
				}
			}
		}
	}

	/**
	 * Given Element e, the function updates variable fieldValues and Hashtable fieldTable.
	 * This is a small hack required not to change the existing function. 
	 * After implmenting above function and using it at many place, I realized that I do not
	 * need to pass doc. 
	 * Later, when doc is not available, did not want to touch the existing code, so added
	 * this function, where e.getOwnerDocument() is passed implicitly and no explicit document
	 * needs to be passed. 
	 * @param e
	 */
	public void updateFieldValues(Element e){
		updateFieldValues(e, e.getOwnerDocument());
	}
	
	public ItemIdentifier cloneItemIdentifier(){
		ItemIdentifier ii = new ItemIdentifier();
		ii.setTarget(this.getTarget());
		ii.setFieldValue(this.getFieldValue());
		ii.setName(this.getName());
		Hashtable ft = new Hashtable();
		Enumeration keyEnumeration = fieldTable.keys();
		while (keyEnumeration.hasMoreElements()){
			Object key = keyEnumeration.nextElement();
			ft.put(key,fieldTable.get(key));
		}
		ii.setFieldTable(ft);
		return ii;
	}

}
