/**
 * 
 */
package cs.arizona.tau.xml;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;

import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;

import cs.arizona.tau.time.ITimePeriod;
import cs.arizona.tau.time.TimePeriod;
import cs.arizona.tau.time.ITemporalRegion;
import cs.arizona.tau.time.TemporalRegion;
import cs.arizona.tau.time.ITime;
import cs.arizona.util.TauLogger;

/**
 * @author spjoshi
 *
 */
public class Item extends BaseItem implements Cloneable{

	private ItemIdentifier itemIdentifier;
	private boolean coalsced;									//Represents whethre the item is coalsced or not
	
	//All these attributes are related to validTime
	private ITimePeriod contentVaryingApplicabilityPeriod;
	private ITimePeriod maximalExistencePeriod;
	private int validTimeFrequency;
	private int content;										//Whether content varying or content constant
	private int existence;										//Whether existence varying or existence constant
	private int kind;											//Kind could be either state or event
	
	//All attributes below are related to transactionTime
	private int transactionTimeFrequency = 0;
	

	/**
	 * 
	 */
	public Item() {
		super();
	}
	
	public String toString(){
		String result;
		result = "Target \"" + target + "\" with id \"" + itemID + "\"";
		return result;
		
	}

	/**
	 * @param item
	 */
	public Item(Item item) {
		super(item);
		this.itemIdentifier = item.itemIdentifier.cloneItemIdentifier();
		this.coalsced = item.isCoalsced();

		//Attributes related to validTime
		this.contentVaryingApplicabilityPeriod = item.getContentVaryingApplicabilityPeriod();
		this.maximalExistencePeriod = item.getMaximalExistencePeriod();
		this.validTimeFrequency = item.getValidTimeFrequency();
		this.content = item.getContent();
		this.existence = item.getExistence();
		this.kind = item.getKind();
		
		//Attributes related to transactionTime
		this.transactionTimeFrequency = item.getTransactionTimeFrequency();
		// TODO Auto-generated constructor stub
	}

	/**
	 * The constructor accepts an Element from Temporal Annotation and creates a prototype of an item. All Versions, TemporalElement
	 * and values inside Item Identifier would be undefined. But this item prototype is used by TemporalAnnotationValidator   
	 * @param itemType
	 * @param xmlSchemaElement
	 */
	public Item(Element xmlSchemaElement) {
		this.target = xmlSchemaElement.getAttribute("target");
		NodeList nl = xmlSchemaElement.getChildNodes();
		for (int i=0 ; i < nl.getLength() ; i++){
			if (nl.item(i).getNodeType() == Node.ELEMENT_NODE){
				Element childElement=(Element)nl.item(i);
				if ("itemIdentifier".equals(childElement.getLocalName())){
					this.itemIdentifier = new ItemIdentifier(childElement);
				}else{
					if ("validTime".equals(childElement.getLocalName())){
						this.timeDimension = ITimePeriod.VALID_TIME;
						this.content = ("constant".equals(childElement.getAttribute("content")))? BaseItem.CONTENT_CONSTANT : BaseItem.CONTENT_VARYING ;
						this.existence = "constant".equals(childElement.getAttribute("existence")) ? BaseItem.EXISTENCE_CONSTANT : (("varyingWithGaps".equals(childElement.getAttribute("existence")))? BaseItem.EXISTENCE_VARYING_WITH_GAPS  : BaseItem.EXISTENCE_VARYING_WITHOUT_GAPS);
						this.kind = ("state".equals(childElement.getAttribute("kind")))? BaseItem.KIND_STATE  : BaseItem.KIND_EVENT ;
						
						NodeList nl1 = childElement.getChildNodes();
						for (int j=0 ; j<nl1.getLength() ; j++){
							if (nl.item(j).getNodeType() == Node.ELEMENT_NODE){
								Element ce1= (Element)nl1.item(j);
								if ("contentVaryingApplicability".equals(ce1.getLocalName())){
									this.contentVaryingApplicabilityPeriod = new TimePeriod(ce1.getAttribute("begin"),ce1.getAttribute("end"));
								}else{ 
									if ("maximalExistence".equals(ce1.getLocalName())){
										this.maximalExistencePeriod = new TimePeriod(ce1.getAttribute("begin"),ce1.getAttribute("end"));
									}else{
										this.validTimeFrequency = Integer.parseInt(ce1.getNodeValue());
									}
								}
							}
						}
					}else{
						if ("transactionTime".equals(childElement.getLocalName())){
							if (this.timeDimension == ITimePeriod.VALID_TIME){
								this.timeDimension = ITimePeriod.BITEMPORAL_TIME;
							}else{
								this.timeDimension = ITimePeriod.TRANSACTION_TIME;
							}
							this.content = ("constant".equals(childElement.getAttribute("content")))? BaseItem.CONTENT_CONSTANT : BaseItem.CONTENT_VARYING ;
							this.existence = "constant".equals(childElement.getAttribute("existence")) ? BaseItem.EXISTENCE_CONSTANT : (("varyingWithGaps".equals(childElement.getAttribute("existence")))? BaseItem.EXISTENCE_VARYING_WITH_GAPS  : BaseItem.EXISTENCE_VARYING_WITHOUT_GAPS);
							this.kind = ("state".equals(childElement.getAttribute("kind")))? BaseItem.KIND_STATE  : BaseItem.KIND_EVENT ;
							NodeList nl1 = childElement.getChildNodes();
							for (int j=0 ; j<nl1.getLength() ; j++){
								if (nl.item(j).getNodeType() == Node.ELEMENT_NODE){
									Element ce1= (Element)nl1.item(j);
									if ("frequency".equals(ce1.getLocalName())){
											this.transactionTimeFrequency = Integer.parseInt(ce1.getNodeValue());
									}
								}
							}
						}
					}
				}
			}
		}
	}
	
	
	
	
	
	
	
	/**
	 * Steve testng
	 * The constructor accepts an Element from Physical. 
	 * @param itemType
	 * @param xmlSchemaElement
	 */
	public Item(Element xmlSchemaElement, boolean dummy) {
		this.target 		= xmlSchemaElement.getAttribute("target");
		this.timeDimension 	= ITimePeriod.TRANSACTION_TIME;
		this.content 		= BaseItem.CONTENT_CONSTANT;
		this.existence 		= BaseItem.EXISTENCE_CONSTANT;
		this.kind 			= BaseItem.KIND_STATE ;
		
		//Build item identifier
		this.itemIdentifier = new ItemIdentifier();
		this.itemIdentifier.setName("id1");
		this.itemIdentifier.setTarget(target);
		this.itemIdentifier.fieldTable.put("./text()","");
		
	}
	
	
	
	
	
	

	/**
	 * @return Returns the content.
	 */
	public int getContent() {
		return content;
	}

	/**
	 * @param content The content to set.
	 */
	public void setContent(int content) {
		this.content = content;
	}

	/**
	 * @return Returns the existence.
	 */
	public int getExistence() {
		return existence;
	}

	/**
	 * @param existence The existence to set.
	 */
	public void setExistence(int existence) {
		this.existence = existence;
	}

	/**
	 * @return Returns the itemIdentifier.
	 */
	public ItemIdentifier getItemIdentifier() {
		return itemIdentifier;
	}

	/**
	 * @param itemIdentifier The itemIdentifier to set.
	 */
	public void setItemIdentifier(ItemIdentifier itemIdentifier) {
		this.itemIdentifier = itemIdentifier;
	}

	/**
	 * @return Returns the kind.
	 */
	public int getKind() {
		return kind;
	}

	/**
	 * @param kind The kind to set.
	 */
	public void setKind(int kind) {
		this.kind = kind;
	}

	/**
	 * @return Returns the optimized.
	 */
	public boolean isCoalsced() {
		return coalsced;
	}

	/**
	 * @return Returns the contentVaryingApplicabilityPeriod.
	 */
	public ITimePeriod getContentVaryingApplicabilityPeriod() {
		return contentVaryingApplicabilityPeriod;
	}

	/**
	 * @param contentVaryingApplicabilityPeriod The contentVaryingApplicabilityPeriod to set.
	 */
	public void setContentVaryingApplicabilityPeriod(
			ITimePeriod contentVaryingApplicabilityPeriod) {
		this.contentVaryingApplicabilityPeriod = contentVaryingApplicabilityPeriod;
	}

	/**
	 * @return Returns the maximalExistencePeriod.
	 */
	public ITimePeriod getMaximalExistencePeriod() {
		return maximalExistencePeriod;
	}

	/**
	 * @param maximalExistencePeriod The maximalExistencePeriod to set.
	 */
	public void setMaximalExistencePeriod(ITimePeriod maximalExistencePeriod) {
		this.maximalExistencePeriod = maximalExistencePeriod;
	}

	/**
	 * @return Returns the transactionTimeFrequency.
	 */
	public int getTransactionTimeFrequency() {
		return transactionTimeFrequency;
	}

	/**
	 * @param transactionTimeFrequency The transactionTimeFrequency to set.
	 */
	public void setTransactionTimeFrequency(int transactionTimeFrequency) {
		this.transactionTimeFrequency = transactionTimeFrequency;
	}

	/**
	 * @return Returns the validTimeFrequency.
	 */
	public int getValidTimeFrequency() {
		return validTimeFrequency;
	}

	/**
	 * @param validTimeFrequency The validTimeFrequency to set.
	 */
	public void setValidTimeFrequency(int validTimeFrequency) {
		this.validTimeFrequency = validTimeFrequency;
	}
	
	/**
	 * Given timeRepresentation, the function converts the given Item to RepItem and returns an instance of RepItem
	 * @param timeRepresentation
	 * @return
	 */
	public RepItem toRepItem(int timeRepresentation){
		RepItem repItem = new RepItem(this.target,this.timeDimension,timeRepresentation);
		repItem.addVersionAll(this.versions, this.temporalElement);
		return repItem;
	}
	
	/*
	 * The function Deep clones the given item and returns it. 
	 * 
	 */
	public Item cloneItem(){
		Item item1 = new Item(this);
		return item1;
	}

	/**
	 * The function coalsces the versions, so as to form the compact representation. 
	 * After coalscing coalsced flag is set to true. 
	 *
	 */
	public void coalsce(Document temporalDoc, LogicalAnnotationValidator tav, String repSchemaNameAlias) {
		Iterator versionIterator = getVersionIterator();
		Iterator teIterator = this.temporalElement.iterator() ;
		
		ArrayList versionToBeRemoved = new ArrayList();

		Element ev1 = null, ev2 = null;
		ITime time1 = null, time2 = null;
		if (versionIterator.hasNext()){
			ev1 = (Element)versionIterator.next();
			time1 = (ITime)teIterator.next();
		}

		while (versionIterator.hasNext()){
			Hashtable ht = new Hashtable();
			ev2 = (Element)versionIterator.next();
			time2 = (ITime)teIterator.next();
			if (((ITimePeriod)time1).getRelationship((ITimePeriod)time2) == ITimePeriod.A_MEETS_B){
				if (canBeCoalsced(ev1,ev2,ht,temporalDoc,tav)== true){
					coalsceTwoVersions(ev1,ht,temporalDoc, repSchemaNameAlias);
					versionToBeRemoved.add(ev2);
					((ITimePeriod)time1).setEndDate(((ITimePeriod)time2).getEndDate());
				}else{
					ev1 = ev2;
					time1 = time2;
				}
			}else{
				ev1 = ev2;
				time1 = time2;
			}
		}
		for (int i=0 ; i<versionToBeRemoved.size() ; i++){
			this.removeVersion((Element)versionToBeRemoved.get(i));
		}
		
		this.coalsced = true;
	}


	/**
	 * The function internally checks all the constraints on the item. 
	 * @return true if the item is valid, else return false.
	 */
	public boolean validate(ITime documentExistenceTime, LogicalAnnotationValidator tav, Document temporalDoc){
		boolean isValid=false;
		/* All the below functions need to be called for items that vary BITEMPORALLY */

		switch(this.timeDimension){
		case ITimePeriod.BITEMPORAL_TIME :	isValid = validateContent(tav, temporalDoc) && validateExistence((ITimePeriod)documentExistenceTime) 
													  && validateKind() && validateContentVaryingApplicability() 
													  && validateMaximalExistence() && validateValidTimeFrequency(tav, temporalDoc) 
													  && validateTransactionTimeFrequency(tav, temporalDoc);
											break;
		case ITimePeriod.VALID_TIME :	isValid = validateContent(tav, temporalDoc) && validateExistence((ITimePeriod)documentExistenceTime) 
												  && validateKind() && validateContentVaryingApplicability() 
												  && validateMaximalExistence() && validateValidTimeFrequency(tav, temporalDoc);
										break;
		case ITimePeriod.TRANSACTION_TIME :	isValid = validateContent(tav, temporalDoc) && validateExistence((ITimePeriod)documentExistenceTime) 
													  && validateKind() && validateTransactionTimeFrequency(tav, temporalDoc);
											break;
		}
		return isValid;
	}
	
	/**
	 * The original equals function is overloaded to customize equality check of two Item.
	 * If the Item Identifiers of two items are equal, then the items are also equal or not equal.
	 * @param o
	 * @return true if specified object is same as the ItemIdentifier
	 */
/*	public boolean equals(Object o){
		Item item = (Item)o;
		if (this.itemIdentifier.equals(item.getItemIdentifier())){
			return true;
		}else{
			return false;
		}
	}
*/
	/* Helper methods required by coalscing begin here*/
	/*
	 * Given 2 versions of an item, the method finds out whether they can be coalsced or not. 
	 * It is decided solely on the basis whether the versions are adjacent or not.
	 * Note : If the two versions are overlapping, it is considered as the error. (The discussion about this 
	 * decision is present in the notebook.)   
	 */
	private boolean canBeCoalsced(Element ev1, Element ev2, Hashtable ht, Document temporalDoc, LogicalAnnotationValidator tav){
		String targetName = "";
		if ("y".equals(ev1.getAttribute("isItem"))){
			targetName = ev1.getAttribute("originalElement");
		}else{
			targetName = ev1.getLocalName();
		}
		if (("y".equals(ev1.getAttribute("isItem"))) && ("y".equals(ev2.getAttribute("isItem")))){
			Item item1 = tav.getItemPrototype(targetName);
			RepItem repItem1 = new RepItem(ev1,targetName);
			item1.addVersionAll(repItem1.getVersions(),repItem1.getTemporalElement());
			item1.getItemIdentifier().updateFieldValues(item1.getVersion(0),temporalDoc);
			Item item2 = tav.getItemPrototype(targetName);
			RepItem repItem2 = new RepItem(ev2,targetName);
			item2.addVersionAll(repItem2.getVersions(),repItem2.getTemporalElement());
			item2.getItemIdentifier().updateFieldValues(item2.getVersion(0),temporalDoc);

			if (item1.getItemIdentifier().equals(item2.getItemIdentifier())){
				item1.merge(item2);
				ht.put(ev1,item1);
				return true;
			}else{
				return false;
			}
		}else{
			NodeList nl = ev1.getChildNodes();
			ArrayList nonAttrNodes1 = new ArrayList();
			//Create ArrayList of Element and text nodes.
			//While doing same, verify whether the other element has same attributes or not.
			for (int i=0 ; i<nl.getLength()  ; i++){
				if ((nl.item(i).getNodeType() == Node.ELEMENT_NODE) || (nl.item(i).getNodeType() == Node.TEXT_NODE)){
					nonAttrNodes1.add(nl.item(i));
				}
			}
			NamedNodeMap nnm = ev1.getAttributes();
			Attr attr = null;
			for (int i=0 ; i<nnm.getLength() ; i++){
				attr = (Attr)nnm.item(i);
				if (!(ev2.getAttribute(attr.getName()).equals(attr.getValue()))){
					return false;
				}
			}

			nl = ev2.getChildNodes();
			ArrayList nonAttrNodes2 = new ArrayList();
			//Create ArrayList of Elemetn and text nodes.
			//While doing same veryfy whether the other element has same attributes or not.
			for (int i=0 ; i<nl.getLength()  ; i++){
				if ((nl.item(i).getNodeType() == Node.ELEMENT_NODE) || (nl.item(i).getNodeType() == Node.TEXT_NODE)){
					nonAttrNodes2.add(nl.item(i));
				}
			}
			nnm = ev1.getAttributes();
			attr = null;
			for (int i=0 ; i<nnm.getLength() ; i++){
				attr = (Attr)nnm.item(i);
				if (!(ev2.getAttribute(attr.getName()).equals(attr.getValue()))){
					return false;
				}
			}			
			
			//Check whether the text collected in previous 2 loops are equal
			//If the node is of type ELEMENT_TYPE, check whether their names are the same.
			if (nonAttrNodes1.size() == nonAttrNodes2.size()){
				for (int i=0 ; i<nonAttrNodes1.size() ; i++){
					Node n = (Node)nonAttrNodes1.get(i);
					Node m = (Node)nonAttrNodes2.get(i);
					if (n.getNodeType() == Node.TEXT_NODE){
						if (m.getNodeType() == Node.TEXT_NODE ){
							if (!(m.getNodeValue().equals(n.getNodeValue()))){
								return false;
							}
						}else{
							return false;
						}
					}else{
						if (!(m.getNodeName().equals(n.getNodeName()))){
							return false;
						}else{
							if (! canBeCoalsced((Element)n,(Element)m,ht,temporalDoc, tav)){
								return false;
							} else {
							}
						}
					}
				}
			}else{
				return false;
			}
		}
		return true;
	}
	
	/*
	 * The method coalsces the two adjacent versions of an item.
	 */
	private void coalsceTwoVersions(Element ev1, Hashtable ht, Document temporalDoc, String repSchemaNameAlias){
		NodeList nl = ev1.getChildNodes();
		for (int i=0 ; i<nl.getLength() ; i++){
			if (nl.item(i).getNodeType() == Node.ELEMENT_NODE){
				Element e = (Element)nl.item(i);
				if (ht.containsKey(e)){
					Item item = (Item)ht.get(e);
					RepItem repItem = item.toRepItem(ITimePeriod.EXTENT_REP); 
					Element temp = repItem.toXML(temporalDoc, repSchemaNameAlias);
					e.getParentNode().replaceChild(temp,e);
				}else{
					coalsceTwoVersions(e,ht,temporalDoc, repSchemaNameAlias);
				}
			}
		}
	}
	/* Helper methods required by Squash and UnSquash end here.*/
	
	
	/* Helper methods required for TemporalValidation begin here.*/
	
	/*
	 * If the content is specified as CONSTANT, the method validates it. 
	 */
	private boolean validateContent(LogicalAnnotationValidator tav, Document temporalDoc){
		if (this.content == BaseItem.CONTENT_CONSTANT){
			/*
			 * For every two consecutive versions, the method validates whether they are same.
			 * Even if any 2 versions are different, the content is nomore CONSTANT and the error is thrown.
			 */
			Iterator versionIterator = getVersionIterator();
			
			Element ev1 = null, ev2 = null;
			if (versionIterator.hasNext()){
				ev2 = (Element)versionIterator.next();
			}

			while (versionIterator.hasNext()){
				ev1 = ev2;
				ev2 = (Element)versionIterator.next();
				if (false == areConstantContentVersions(ev1, ev2, tav, temporalDoc)){
					TauLogger.logger.fatal("Content is specified as CONTENT_CONSTANT but is not CONSTANT for Item with Item Identifier:\n" + this.itemIdentifier.toString());

					return false;			
				}
			}
			return true;
		}else{
			return true;
		}
	}
	
	/*
	 * Validating existence constraints is bit more complicated after the discussion with Dr. Snodgrass and Curtis.
	 * The Existence-Constant has 2 types
	 * 1) existence-constant is with respect to its parent's lifetime
	 *    item lifetime = Union of parent(s)'s lifetime
	 *    - This can be checked by taking the union of the existence temporal elements of its parent(s) and seeing if 
	 *    this is *equal* to the union of the existence temporal elements of a child.
	 * 2) existence-constant-within-document is with respect to the lifetime of the document
	 *    item lifetime = document lifetime
	 *    - This can be checked by comparing the existence of the element with total existence period of the document.
	 *    This validation is kind of simple validation, so initially we will implement only this validation. 
	 *    Validation of type 1 will be implemented later.
	 * 
	 */
	private boolean validateExistence(ITimePeriod documentExistencePeriod){
		Iterator teItr = this.temporalElement.iterator();
		ITimePeriod tp1;
		ITimePeriod tp2;
		if (this.timeDimension == ITimePeriod.BITEMPORAL_TIME){
			tp2 = ((ITemporalRegion)teItr.next()).getValidPeriod();
		}else{
			tp2 = (ITimePeriod)teItr.next();
		}
		
		/*
		 * As explained above, there are 2 notions of existence constants. 
		 * Below we are checking the 2nd one.
		 * First one needs to be incorporated later. 
		 *  
		 * 2) check whether the timespan of element is same as that of entire document
		 */
		if (this.existence == BaseItem.EXISTENCE_CONSTANT){
			ITimePeriod ts = null;		//Time Span of the item
			if (this.timeDimension == ITimePeriod.BITEMPORAL_TIME){
				//Get timespan of the validPeriod of temporal region.
				// TODO
			}else{
				ts = (ITimePeriod)this.temporalElement.getTimeSpan();
			}
			if (!(documentExistencePeriod.getRelationship(ts) == ITimePeriod.A_EQUALS_B)){
				System.out.println("Existence is specified as constant, but it is not constant for the item with Item Identifier - " + this.itemIdentifier.toString());
				
				return false;
			}
		} 

		/*
		 * If an item is EXISTENCE_CONSTANT 'With Respect To The Parent', or EXISTENCE_VARYING_WITHOUT_GAPS, there should not be any gaps between the
		 * existence of various versions of an element. If there exist any gaps, that is an error.
		 */
		if ((this.existence == BaseItem.EXISTENCE_CONSTANT) || (this.existence == BaseItem.EXISTENCE_VARYING_WITHOUT_GAPS)){
			while (teItr.hasNext()){
				tp1 = tp2;
				if (this.timeDimension == ITimePeriod.BITEMPORAL_TIME){
					tp2 = ((ITemporalRegion)teItr.next()).getValidPeriod();
				}else{
					tp2 = (ITimePeriod)teItr.next();
				}
				int rel = tp1.getRelationship(tp2);
				//As per the decision, if two versions are overlapping, it is considered as the error.
				//So only relationship possible between the two items is, A_MEETS_B
				if ((rel != ITimePeriod.B_MEETS_A) && (rel != ITimePeriod.A_MEETS_B)){
					TauLogger.logger.fatal("Existence is specified as 'EXISTENCE CONSTANT' or 'EXISTENCE VARYING WITH GAPS', but constraint is not satisfied for the item with Item Identifier - " + this.itemIdentifier.toString());
					TauLogger.logger.fatal("Timeperiods: " + tp1.toString() + " and " + tp2.toString());
					return false; 
				}
			}
		}
		return true;
	}
	
	/*
	 * Not yet sure, what Kind is exactly. 
	 */
	private boolean validateKind(){
		return true;
	}
	
	private boolean validateContentVaryingApplicability(){

		/* Find out the number of versions of an element before start of contentVaryingApplicabilityPeriod and
		 * after end of contentVaryingApplicabilityPeriod. If they are <=1, the item is valid otherwise, its 
		 * changing beyond the Applicability period mentioned. */
		
		Iterator teIterator = this.temporalElement.iterator();
		int beforeCount = 0;
		int afterCount = 0;
		ITimePeriod tp = null;
		while (teIterator.hasNext()){
			if (this.timeDimension == ITimePeriod.BITEMPORAL_TIME){
				tp = ((ITemporalRegion)teIterator.next()).getValidPeriod();
			}else{
				tp = (ITimePeriod)teIterator.next();
			}
			int rel = contentVaryingApplicabilityPeriod.getRelationship(tp);
			if ((rel == ITimePeriod.B_BEFORE_A) || (rel == ITimePeriod.B_MEETS_A)){
				beforeCount++;
			}
			
			if ((rel == ITimePeriod.A_BEFORE_B) || (rel == ITimePeriod.A_MEETS_B)){
				afterCount++;
			}
		}
		if ((beforeCount <= 1) && (afterCount <= 1)){
			return true;
		}else{
			return false;
		}
	}
	
	private boolean validateMaximalExistence(){

		/* Ensure that the element exists only within the range of maximalExistencePeriod. */

		if (this.timeDimension == ITimePeriod.BITEMPORAL_TIME){
			
		}else{
			ITimePeriod ts= (ITimePeriod)temporalElement.getTimeSpan();
			int rel = maximalExistencePeriod.getRelationship(ts); 
			if ((rel == ITimePeriod.A_BEFORE_B) ||
					(rel == ITimePeriod.A_MEETS_B) ||
					(rel == ITimePeriod.B_MEETS_A) ||
					(rel == ITimePeriod.B_BEFORE_A) ||
					(rel == ITimePeriod.A_OVERLAPS_B) ||
					(rel == ITimePeriod.B_OVERLAPS_A)){
				return false;
			}else{
				return true;
			}
		}
		return true;
	}
	
	private boolean validateValidTimeFrequency(LogicalAnnotationValidator tav, Document temporalDoc){
		int frequency = 0;
		if (ITimePeriod.BITEMPORAL_TIME == this.timeDimension){
			return true;
		}else{
			if (ITimePeriod.VALID_TIME == this.timeDimension){
				//Find out the total number of distinct versions present inside an item assuming that an item is not coalsced.
				//If that number exceeds this.validTimeFrequency, its an error, otherwise the condition is satisfied.
				Iterator versionIterator = getVersionIterator();
				Iterator teIterator = this.temporalElement.iterator() ;
				
				Element ev1 = null, ev2 = null;
				ITime time1 = null, time2 = null;
				if (versionIterator.hasNext()){
					ev1 = (Element)versionIterator.next();
					time1 = (ITime)teIterator.next();
				}

				while (versionIterator.hasNext()){
					ev1 = ev2;
					time1 = time2;
					ev2 = (Element)versionIterator.next();
					time2 = (ITime)teIterator.next();
					if (false == areConstantContentVersions(ev1, ev2, tav, temporalDoc)){
						frequency++;	
					}
				}
				if (frequency <= this.validTimeFrequency){
					return true;
				}else{
					return false;
				}
			}
			return true;
		}
	}
	
	/* 	Find out the total number of distinct versions present inside an item assuming that an item is not coalsced.
	 *	If that number exceeds this transactionTimeFrequency, its an error, otherwise the condition is satisfied.
	 */
	private boolean validateTransactionTimeFrequency(LogicalAnnotationValidator tav, Document temporalDoc){
		int frequency = 0;
		
		if (this.transactionTimeFrequency !=0 ){
			Iterator versionIterator = getVersionIterator();
			
			Element ev1 = null, ev2 = null;
			if (versionIterator.hasNext()){
				ev1 = (Element)versionIterator.next();
			}
	
			while (versionIterator.hasNext()){
				ev1 = ev2;
				ev2 = (Element)versionIterator.next();
				if (false == areConstantContentVersions(ev1, ev2, tav, temporalDoc)){
					frequency++;	
				}
			}
			if (frequency <= this.transactionTimeFrequency){
				return true;
			}else{
				return false;
			}
		}else{
			return true;
		}
	}

	/*
	 * The function returns whether the element versions ev1 and ev2 have the same content or not.
	 * The logic used would be similar to the logic used for canBeCoalsced(...) function. 
	 * But here book-keeping required in canBeCoalsced(...) like HashTable, should not be required.
	 * Need to code this function.
	 */
	private boolean areConstantContentVersions(Element ev1, Element ev2, LogicalAnnotationValidator tav, Document temporalDoc){
		String targetName = "";
		if ("y".equals(ev1.getAttribute("isItem"))){
			targetName = ev1.getAttribute("originalElement");
		}else{
			targetName = ev1.getLocalName();
		}
		/* Following code (if then else condition) will work if physicalToTemporalConversion() function is used, 
		 * otherwise the condition will change to
		 * 
		 * if (tav.containsTarget(newPath)){
		 * 	Item item1 = tav.getItemPrototype(newPath);
		 * 	item1.getItemIdentifier().updateFieldValues(ev1,temporalDoc);
		 * 	Item item2 = tav.getItemPrototype(newPath);
		 * 	item2.getItemIdentifier().updateFieldValues(ev2,temporalDoc);
		 *	if (item1.getItemIdentifier().equals(item2.getItemIdentifier())){
		 *		return true;
		 *	}else{
		 *		return false;
		 *	}
		 * }else{
		 * 	//Other code will remain the same.
		 * }
		 * 
		 */
		
		if (("y".equals(ev1.getAttribute("isItem"))) && ("y".equals(ev2.getAttribute("isItem")))){
			Item item1 = tav.getItemPrototype(targetName);
			RepItem repItem1 = new RepItem(ev1,targetName);
			item1.addVersionAll(repItem1.getVersions(),repItem1.getTemporalElement());
			item1.getItemIdentifier().updateFieldValues(item1.getVersion(0),temporalDoc);
			Item item2 = tav.getItemPrototype(targetName);
			RepItem repItem2 = new RepItem(ev2,targetName);
			item2.addVersionAll(repItem2.getVersions(),repItem2.getTemporalElement());
			item2.getItemIdentifier().updateFieldValues(item2.getVersion(0),temporalDoc);

			if (item1.getItemIdentifier().equals(item2.getItemIdentifier())){
				return true;
			}else{
				return false;
			}
		}else{
			NodeList nl = ev1.getChildNodes();
			ArrayList nonAttrNodes1 = new ArrayList();
			//Create ArrayList of Element and text nodes.
			//While doing same, verify whether the other element has same attributes or not.
			for (int i=0 ; i<nl.getLength()  ; i++){
				if ((nl.item(i).getNodeType() == Node.ELEMENT_NODE) || (nl.item(i).getNodeType() == Node.TEXT_NODE)){
					nonAttrNodes1.add(nl.item(i));
				}
			}
			NamedNodeMap nnm = ev1.getAttributes();
			Attr attr = null;
			for (int i=0 ; i<nnm.getLength() ; i++){
				attr = (Attr)nnm.item(i);
				if (!(ev2.getAttribute(attr.getName()).equals(attr.getValue()))){
					return false;
				}
			}

			nl = ev2.getChildNodes();
			ArrayList nonAttrNodes2 = new ArrayList();
			//Create ArrayList of Elemetn and text nodes.
			//While doing same veryfy whether the other element has same attributes or not.
			for (int i=0 ; i<nl.getLength()  ; i++){
				if ((nl.item(i).getNodeType() == Node.ELEMENT_NODE) || (nl.item(i).getNodeType() == Node.TEXT_NODE)){
					nonAttrNodes2.add(nl.item(i));
				}
			}
			nnm = ev1.getAttributes();
			attr = null;
			for (int i=0 ; i<nnm.getLength() ; i++){
				attr = (Attr)nnm.item(i);
				if (!(ev2.getAttribute(attr.getName()).equals(attr.getValue()))){
					return false;
				}
			}			
			
			//Check whether the text collected in previous 2 looops are equal
			//If the node is of type ELEMENT_TYPE, check whether their names are the same.
			if (nonAttrNodes1.size() == nonAttrNodes2.size()){
				for (int i=0 ; i<nonAttrNodes1.size() ; i++){
					Node n = (Node)nonAttrNodes1.get(i);
					Node m = (Node)nonAttrNodes2.get(i);
					if (n.getNodeType() == Node.TEXT_NODE){
						if (m.getNodeType() == Node.TEXT_NODE ){
							if (!(m.getNodeValue().equals(n.getNodeValue()))){
								return false;
							}
						}else{
							return false;
						}
					}else{
						if (!(m.getNodeName().equals(n.getNodeName()))){
							return false;
						}else{
							if (areConstantContentVersions((Element)n,(Element)m, tav, temporalDoc) == false){
								return false;
							}
						}
					}
				}
			}else{
				return false;
			}
		}
		return true;
	}
	
	/*
	 * Not sure whether this function is required anymore or not.
	 */
	private void orderVersions(){
		ITimePeriod tp1=null;
		ITimePeriod tp2=null;
		for (int i=0 ; i<versions.size() ; i++ ){
			for (int j=i+1 ; j<versions.size() ; j++){
				if (this.timeDimension == ITimePeriod.BITEMPORAL_TIME){
					tp1 = ((ITemporalRegion)this.temporalElement.get(i)).getValidPeriod();
					tp2 = ((ITemporalRegion)this.temporalElement.get(j)).getValidPeriod();
				}else{
					tp1 = (ITimePeriod)this.temporalElement.get(i);
					tp2 = (ITimePeriod)this.temporalElement.get(j);
				}
				int rel = tp1.getRelationship(tp2);
				if ((rel == ITimePeriod.A_BEFORE_B  )||	
						(rel == ITimePeriod.A_MEETS_B )){
					this.temporalElement.swap(i,j);
					swapVersions(i,j);
				}else{
					if ((rel == ITimePeriod.A_OVERLAPS_B)||
						(rel == ITimePeriod.B_STARTS_A  )||
						(rel == ITimePeriod.B_FINISHES_A)||
						(rel == ITimePeriod.B_DURING_A  )){
						//Should throw an error, since timeperiod overlaps are not allowed.
					}
				}
			}
		}
	}
	
	/*
	 * Not sure, whether this function is required anymore or not.
	 */
	private void swapVersions(int ind1, int ind2){
		Object o = versions.get(ind1);
		versions.set(ind2,versions.get(ind1));
		versions.set(ind1,o);
	}
	
	public boolean equals(Object o){
		Item i = (Item)o;
		return this.itemIdentifier.equals(i.getItemIdentifier());
	}
	
	public int hashCode(){
		return this.itemIdentifier.hashCode();
	}
}
