/*
 * Created on Sep 13, 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package cs.arizona.tau.xml;


import org.w3c.dom.*;

import org.w3c.dom.ls.LSException;


import cs.arizona.tau.docs.AnnotationDocument;
import cs.arizona.tau.docs.ConventionalSchema;
import cs.arizona.tau.docs.TemporalSchema;
import cs.arizona.tau.time.ITimePeriod;
import cs.arizona.tau.time.TimePeriod;
import cs.arizona.tau.time.ITemporalRegion;
import cs.arizona.tau.time.TemporalRegion;
import cs.arizona.util.*;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ArrayList;


/**
 * @author shailesh
 * @author sthomas
 * 
 * The class is used for generating a (squashed) Temporal Document from 
 * a set of snapshot documents.
 * 
 */

public class DoSquashing implements IDoSquashing{

	private Document temporalSchemaDoc;
	
	private String   temporalSchema,
					 conventionalSchema,
					 annotation,
					 mOutputFileName = "squashed.xml";

	private Document conventionalSchemaDoc;	    //Document element for snapshot schema. 
	private Document temporalDoc = null;	//Document element for temporal document.
	private Document annotationDoc;			// Document element for annotations.
	private Document defaultAnnotationDoc = null;

	TargetIdentifier         ti;
	LogicalAnnotationValidator lav;
	PhysicalAnnotationValidator pav;
	PhysicalAnnotationValidator defaultPav;
	
	ValidatorProperties vp;
	ConventionalParser  cp;
	
	String repSchemaNameAlias;
	
	/**
	 * Initializes lsParser and lsSerializer objects to be used later for parsing.
	 * Also initializes the logger object.
	 */
	private void init(){
		vp = ValidatorProperties.getInstance();
		cp = ConventionalParser.getInstance();
		repSchemaNameAlias = "";
		TauLogger.init();
	}
	
	
	/**
	 * Initializes lsParser and lsSerializer objects to be used later for parsing.
	 * Also initializes the logger object.
	 */
  private void init(int schemaVersion){
    if (schemaVersion >=0 ){
      repSchemaNameAlias = vp.getProperty("RepSchemaNameAlias") + schemaVersion + ":";
    }else{
      repSchemaNameAlias = "";
    }
    // Don't want schema version in the namespace.
    // Oct 11 temporalDoc       = cp.createDocument(vp.getProperty("RepSchemaURL"), repSchemaNameAlias + "temporalRoot", null);
    temporalDoc       = cp.createDocument("", repSchemaNameAlias + "temporalRoot", null);
    //conventionalSchemaDoc = cp.parseDocument(conventionalSchema, null, vp.getProperty("XMLSchema"), false);
    //Initialize SchemaPathEvaluator
    ti = new TargetIdentifier(conventionalSchemaDoc);
    // Create Document objects from the temp and phys annotation file names
    //annotationDoc = cp.parseDocument(annotation, null, vp.getProperty("ASchema"));
    defaultAnnotationDoc = Common.createDefaultAnnotationDoc(cp, Common.getTopLevelSchemaElementName(ti));
    //Validate Temporal and Physical Annotations	
    lav 		= new LogicalAnnotationValidator(annotationDoc,conventionalSchemaDoc,ti,true);
    pav 		= new PhysicalAnnotationValidator(annotationDoc,conventionalSchemaDoc,ti,true);
    defaultPav 	= new PhysicalAnnotationValidator(defaultAnnotationDoc,conventionalSchemaDoc,ti,true);
    Common.validateAnnotations(lav, pav);
  }

	
	/**
	 *    Called from DecomposedRepresentationFactory.createSquashingObj()
	 */
	public DoSquashing(String temporalSchema, int schemaVersion) {
		init();
		this.temporalSchema = temporalSchema;
		
		// Get the snapshotSchemas
		//parseTemporalSchema();
		TemporalSchema ts = new TemporalSchema(vp, cp, temporalSchema);
		temporalSchemaDoc = ts.getTemporalSchemaDoc();
		annotationDoc = ts.getAnnotationDoc();
		conventionalSchemaDoc = ts.getConventionalSchemaDoc();
		init(schemaVersion);
	}
	
	/**
	 *    Called from TemporalValidator
	 */
	public DoSquashing() {
		init();
		temporalDoc = cp.createDocument("",  "temporalRoot", null);
	}
	
	
	/**
	 * 
	 * @param snapshotSchema
	 * @param temporalAnnotation
	 * @param physicalAnnotation
	 * @param schemaVersion
	 */
	// Called from DoSVSquashing.squash()
	public DoSquashing(String snapshotSchema, String annotation, int schemaVersion) {
        init();
        this.conventionalSchema     = snapshotSchema;
        this.annotation				= annotation;
		init(schemaVersion);
	}
	
	/**
	 * @author sthomas
	 */
	public void setOutputFileName(String tempDataDir, String name){
		mOutputFileName = tempDataDir + "/" + name;
	}
	
	
	
	/**
	 * Interface for main squash function.
	 */
	public Document squash(String tempDataDir, String tempDataFile) {

		Document temporalDoc = null;
		String   temporalDir = "";
		
		temporalDir = Common.getDirectory(tempDataFile) ;
		
		temporalDoc = cp.parseDocument(tempDataDir + "/" + tempDataFile, null, vp.getProperty("TDSchema"));
		
//		InternalTemporalDocument itd = new InternalTemporalDocument(temporalDoc);
//		itd.GetInternalTemporalDocument(tempDataDir, ti, lav, defaultPav);
		
		// Determine which representation we need to use and call the 
		// appropriate function.
		if (pav.getRepType().equals("edit")){
			System.out.println("edit based squashing");
			return squashEdit(temporalDir, temporalDoc.getDocumentElement());
		} 
		else if (pav.getRepType().equals("versioned")){
			System.out.println("item based squashing");
			return squash(tempDataDir, temporalDir, temporalDoc.getDocumentElement());
		}
		TauLogger.logger.info("Unknown representation type \"" + pav.getRepType() +"\"");
		System.exit(3); //TODO: something smarter.
		return null;
	}
	
	
	/**
	 * @author sthomas
	 * @param temporalDir
	 * @param temporalRootElement
	 * Given a set of Snapshot Documents, creates edit-based temporal document.
	 */
	public Document squashEdit(String temporalDir, Element temporalRootElement) {
		
		/*
		 *  The top level element <temporalRoot> has been created inside function init().
		 *  This function parses the snapshot documents specified in configFile one by one
		 *  We then call diff -e and generate <edit> tags.
		 */
		
       	long t1e = System.nanoTime();
		String 	 beginDate       = "", 
				 endDate         = "",
				 snapshotFile    = "",
				 firstDate		 = "", 
				 lastDate		 = "",
				 lastFile		 = "",
				 newFile 		 = "",
				 originalRoot    = "";
		Document snapshotDoc     = null;
		Element  temporalRoot    = temporalDoc.getDocumentElement();	
		NodeList nl              = temporalRootElement.getElementsByTagName("slice");
		int lastI				 = nl.getLength() - 1;
		Element root1   		 = null;

    	TauLogger.logger.info("Squashing with edit-based representation.");
    	
       	long t1l = System.nanoTime();
		// For each "snapshot" element in the config file
		for (int i = lastI ; i >= 0 ; --i){
			Element currElement = (Element)nl.item(i);
			
			beginDate = currElement.getAttribute("begin");
			endDate   = currElement.getAttribute("end");
			if (endDate == ""){
				endDate="9999-12-31";
			}
			
			ITimePeriod transactionPeriod = new TimePeriod(beginDate, endDate);
			
			snapshotFile    = temporalDir + currElement.getAttribute("location");
			snapshotDoc     = cp.parseURI(snapshotFile);
			Element time 	= transactionPeriod.toXML(ITimePeriod.TRANSACTION_TIME, ITimePeriod.EXTENT_REP, temporalDoc);
			Element root2 	= temporalDoc.getDocumentElement();
			
			
			/* For the first file, just append the entire file with a timestamp surrounding. */
			if (i == lastI){
				lastDate = endDate;
				
				// Filter the input file (see Steve's Thesis for more information)
				newFile =  snapshotFile + ".tmp";
				Common.filterEditInput(snapshotFile, newFile);
				
				// Put file in <time> element, and add <time> element to root.
				snapshotDoc      	= cp.parseURI(newFile);
	            root1 				= snapshotDoc.getDocumentElement();
	            Node importedNode 	= temporalDoc.importNode(root1, true);
	            time.appendChild(importedNode);
	            root2.appendChild(time);
	            
	            lastFile = snapshotFile;
	            originalRoot = root1.getLocalName();
	            Common.deleteFile(newFile);
			} else {
			/* For all other files, need to run diff command */
				firstDate = beginDate;
				Common.runDiffCommand(lastFile, snapshotFile, temporalDoc, root2, beginDate, endDate);
				lastFile = snapshotFile;
			}
			
			
		} // end snapshot file loop
       	long t2l = System.nanoTime();
	   	Common.printElaspedTime("      loop", t1l, t2l);
		
		// firstDate and lastDate are saved in the loop above.
		temporalRoot.setAttribute("begin", firstDate);
		temporalRoot.setAttribute("end", lastDate);
		temporalRoot.setAttribute("originalRoot", originalRoot);
		temporalRoot.setAttribute("xmlns:tv", vp.getProperty("TVSchemaURL"));
		
		// TODO: (Oct 2008) Add the schemaLocation(s) as discussed in TR meeting.
		temporalRoot.setAttribute("temporalSchemaLocation", "TODO");
		
		cp.writeDocument(temporalDoc, mOutputFileName);
       	long t2e = System.nanoTime();
	   	Common.printElaspedTime("   squashEdit", t1e, t2e);
		return temporalDoc;
	}
	
	
	/**
	 * @author shailesh
	 * @author sthomas
	 * @param temporalDir
	 * @param temporalRootElement
	 * Given a set of Snapshot Documents, Temporal and Physical Annotations the function generates Temporal Document.
	 * All the document paths are specified inside configFile.
	 */
	public Document squash(String tempDataDir, String temporalDir, Element temporalRootElement) {
        long t1 = System.nanoTime();

		TauLogger.logger.info("Squashing with item-based representation.");
		 //  This function creates a repItem from the temporalRoot node; it the loops through
		 //  all slices and adds their root nodes as versions to temporalRoot repItem. The result is 
		 //  temporalRoot with timestamp at the root; we then call pushDown() function as appropriate.
				
		String 	 beginDate       = "", 
				 endDate         = "",
				 snapshotFile    = "",
				 firstDate		 = "";
		Document snapshotDoc     = null;
		Element  importedElement = null,
				 temporalRoot    = temporalDoc.getDocumentElement();	
		RepItem  repItem		 = null;
		
		// Copy temporalSchemaSet to output document
		NodeList tempSchemaSet = temporalRootElement.getElementsByTagName("temporalSchema");
		Element temporalSchemaSet = temporalDoc.createElement("temporalSchemaSet");
		for(int i = 0; i < tempSchemaSet.getLength(); i++) {
			Element temporalSchema = temporalDoc.createElement("temporalSchema");
			temporalSchema.setAttribute("schemaLocation", ((Element) tempSchemaSet.item(i)).getAttribute("schemaLocation"));
			temporalSchemaSet.appendChild(temporalSchema);
		}
		
		NodeList nl = temporalRootElement.getElementsByTagName("slice");

        long t1r = System.nanoTime();
		// Create a rep item on the root node.
		repItem = new RepItem(Common.getTopLevelSchemaElementName(ti), 
				ITimePeriod.TRANSACTION_TIME, ITimePeriod.EXTENT_REP); 
	    long t2r = System.nanoTime();
		Common.printElaspedTime("   RepItem", t1r, t2r);
	
        long t1l = System.nanoTime();
		// For each "snapshot" element in the config file
		for (int i = 0 ; i < nl.getLength() ; ++i){
			Element currElement = (Element)nl.item(i);
			
			beginDate = currElement.getAttribute("begin");
			endDate   = currElement.getAttribute("end");
			if (endDate == ""){
				endDate="9999-12-31";
			}
			if (i == 0){
				firstDate = beginDate;
			}
			
			ITimePeriod transactionPeriod = new TimePeriod(beginDate, endDate);
			
			// At start, topmost element should always have both valid as well as transaction time periods
			// in case, if they are required by the targets down the tree.	
			// NOTE: Only transaction time has currently been implemented.
			//snapshotFile     = temporalDir + currElement.getAttribute("location");
			snapshotFile     = tempDataDir + "/" + currElement.getAttribute("location");
			TauLogger.logger.info("Squashing slice " + snapshotFile);
			snapshotDoc      = cp.parseURI(snapshotFile);
			importedElement  = (Element)temporalDoc.importNode(snapshotDoc.getDocumentElement(),true);
			
			
			
			// Steve's NOTE: Not sure why the following function is called? May need to look into this.
			removeStandardAttributesFromRootNode(importedElement);
			repItem.addVersion(importedElement, transactionPeriod);
		}
	    long t2l = System.nanoTime();
		Common.printElaspedTime("   Loop", t1l, t2l);
		
		
		
		//Set beginDate of <temporalRoot> as beginDate of first Document
		temporalRoot.setAttribute("begin", firstDate);
		
		//Set endDate of <temporalRoot> as endDate of last document, which is obtained from last iteration of above loop
		temporalRoot.setAttribute("end", endDate);
		temporalRoot.setAttribute("xmlns:tv", vp.getProperty("TVSchemaURL"));
		temporalRoot.appendChild(repItem.toXML(temporalDoc, repSchemaNameAlias));
		
		// At this point, the temporalDoc currently has timestamp at root.
		
		if (true){ // Original methodology. Works.
			
        	long t1p = System.nanoTime();
			TauLogger.logger.info("Physical to Temporal conversion");
			Primitives primitives = new Primitives(ti, lav, defaultPav, repSchemaNameAlias);
			primitives.physicalToTemporalConversion(temporalDoc);
        	long t2p = System.nanoTime();
	    	Common.printElaspedTime("   PhysToTemp", t1p, t2p);
        	long t1t = System.nanoTime();
			TauLogger.logger.info("Temporal to Physical conversion");
			primitives = new Primitives(ti, lav, pav, repSchemaNameAlias);
			primitives.temporalToPhysicalConversion(temporalDoc);
        	long t2t = System.nanoTime();
	    	Common.printElaspedTime("   tempToPhys", t1t, t2t);
	    	// Add the temporalSchemaSet to the top
	    	temporalRoot.insertBefore(temporalSchemaSet, temporalRoot.getFirstChild());
	    	
			// Write out the resulting document in the current directory.
			cp.writeDocument(temporalDoc, mOutputFileName);
		}
		else { // Steve's play grounds. Can we remove the dependence on temporal annotations? Currently doesn't work.
			
			// New Idea: push each physical annotation down, just like the physToTemp does.
			// NOTE: currently doesn't work.
			Primitives primitives = new Primitives(ti, lav, pav, repSchemaNameAlias);
			primitives.rootToPhysicalConversion(temporalDoc);
			cp.writeDocument(temporalDoc, mOutputFileName);
		}

        long t2 = System.nanoTime();
	    Common.printElaspedTime("squashItem", t1, t2);
		
		return temporalDoc;
	}
	
	
	
	/**
	 * @author sthomas
	 * @param docs
	 * Given a hashtable of the form (TimePeriod, Document), squash the documents with the default
	 * physical and temporal annotations. Used by TemporalValidator for edit-based reps.
	 */
	public Document squashDefault(ArrayList docs) {
        long t1 = System.nanoTime();

		TauLogger.logger.info("Squashing with item-based representation, default physical annotations.");
		 //  This function creates a repItem from the temporalRoot node; it the loops through
		 //  all slices and adds their root nodes as versions to temporalRoot repItem. The result is 
		 //  temporalRoot with timestamp at the root;
				
		String 	 beginDate       = "", 
				 endDate         = "",
				 snapshotFile    = "",
				 firstDate		 = "",
				 lastDate		 = "",
				 originalRoot    = "";
		Document snapshotDoc     = null;
		Element  importedElement = null,
				 temporalRoot    = temporalDoc.getDocumentElement();	
		RepItem  repItem		 = null;
			
		 
		// Create a rep item on the root node. (TODO: getting the root node below is ugly. Is there another way?)
		// TODO: what to do in the case that the root changes between versions?
		SnapshotContainer sc1 	= (SnapshotContainer)docs.get(0);
		Document d  			= cp.parseDocument(sc1.fileName, null, "", false);
		String rootName 		= d.getDocumentElement().getLocalName();
		
		
		repItem = new RepItem(rootName, TimePeriod.TRANSACTION_TIME, ITimePeriod.EXTENT_REP); 
		
		int i = 0;
		// Now loop through snapshots and add each one
		for (int j=docs.size()-1; j >= 0; --j){
        	//long t1l = System.nanoTime();

			SnapshotContainer sc = (SnapshotContainer)docs.get(j);
		    ITimePeriod tp = sc.tp;
		    snapshotFile   = sc.fileName;
			snapshotDoc    = cp.parseDocument(snapshotFile, null, null, false);
			
			beginDate = Common.formatDate2(tp.getBeginDate());
			endDate   = Common.formatDate2(tp.getEndDate());
			
			if (i++ == 0){
				originalRoot = snapshotDoc.getDocumentElement().getLocalName();
				firstDate = beginDate;
			} else{
				lastDate = endDate;
			}

			importedElement  = (Element)temporalDoc.importNode(snapshotDoc.getDocumentElement(),true);
			
			removeStandardAttributesFromRootNode(importedElement);
			repItem.addVersion(importedElement, tp);
        //long t2l = System.nanoTime();
	    //Common.printElaspedTime("  Loop", t1l, t2l);
		}
		 
		//Set beginDate of <temporalRoot> as beginDate of first Document
		temporalRoot.setAttribute("begin", firstDate);
		temporalRoot.setAttribute("end",   lastDate);
		temporalRoot.setAttribute("originalRoot", originalRoot);
		temporalRoot.setAttribute("xmlns:tv", vp.getProperty("TVSchemaURL"));
		temporalRoot.appendChild(repItem.toXML(temporalDoc, repSchemaNameAlias));
			
        long t2 = System.nanoTime();
	    Common.printElaspedTime("squashDefault", t1, t2);
		return temporalDoc;
	}
	
	
	/**
	 * TODO: Why do we need this function? Try to justify its existence.
	 */
	private void removeStandardAttributesFromRootNode(Element element){
		Hashtable ht = new Hashtable();
		ArrayList remAttrs = new ArrayList();
			
		ht.put("attributeFormDefault", "");
		ht.put("elementFormDefault", "");
		NamedNodeMap nnm = element.getAttributes();
		for (int i=0 ; i<nnm.getLength() ; i++){
			Node n = nnm.item(i);
				// ORIG if ((ht.containsKey(n.getNodeName())) || (n.getNodeName().startsWith("xmlns")) || (n.getNodeName().startsWith("xsi"))){
				if ((ht.containsKey(n.getNodeName())) || (n.getNodeName().startsWith("xsi"))){
					remAttrs.add(n.getNodeName());
				}
		}
		for (int i=0 ; i< remAttrs.size() ; i++){
			element.removeAttribute((String)remAttrs.get(i));
			TauLogger.logger.debug("Removing attribute \"" + (String)remAttrs.get(i) + "\" from element \"" + element.getLocalName() + "\"");
		}
	}
}
