/**
 * 
 */
package cs.arizona.tau.xml;

import java.util.ArrayList;
import java.util.Hashtable;

import org.w3c.dom.*;
import org.w3c.dom.ls.*;

import cs.arizona.util.*;

import cs.arizona.tau.time.ITimePeriod;
import cs.arizona.tau.time.TimePeriod;

/**
 * @author Shailesh Joshi
 *
 */
public class DoSVSchemaMapping implements IDoSchemaMapping{

	private Document repSchema;
	
	private ConventionalParser cp;
	private ValidatorProperties vp;

	private String xmlSchemaName;				//Name representing "http://www.w3.org/2001/XMLSchema" in the document element node.
	private String tvSchemaName;			//Name representing "http://www.cs.arizona.edu/TVSchema" in the document element node.
													//Though the value is fixed at "tv:" for time being, it could be changed later.
	
	private ArrayList itemIdCorrList;
	
	private ArrayList scpTimeSpanList;
	
	/**
	 * 
	 */
	public DoSVSchemaMapping() {
		super();
		init();
	}

	private void init(){
		cp = ConventionalParser.getInstance();
		vp = ValidatorProperties.getInstance();
		xmlSchemaName = vp.getProperty("XMLSchemaNameAlias");
		tvSchemaName = vp.getProperty("TVSchemaNameAlias");
		itemIdCorrList = new ArrayList();
		scpTimeSpanList = new ArrayList();
	}

	/**
	 * Creates a Representational schema document from given set of Snapshot document,Temporal and Physical Annotations and Temporal Bundle.
	 * The Representational Schema Document will be written at location specified by representationalSchema.  
	 * @param temporalBundle			- Path of temporal bundle document
	 * @param representationalSchema	- Path of representational schema
	 */
	public Document createRepresentationalSchema(String temporalBundle) {

		String snapshotSchema;
		String temporalAnnotation;
		String physicalAnnotation;
		String temporalBundleDir;
		String beginDate="",  endDate ="";
		Element schemaElement;
		
		temporalBundleDir = temporalBundle.substring(0,temporalBundle.lastIndexOf("/")) + "/";
		
		schemaElement = createSchemaElement();

		Document bundleDoc;
		bundleDoc = cp.parseDocument(temporalBundle, null, vp.getProperty("TBSchema"));
		NodeList schemaAnnotationNodes = bundleDoc.getElementsByTagName("schemaAnnotation");
		
		/* Known Bug : Even though all the attributes of the "schema" element are being set, they are not getting
		 * written to the file. They are shown in watch properly as attributes of the element, but not printed.
		 */
		for (int i=0 ; i<schemaAnnotationNodes.getLength() ; i++){
			schemaElement.setAttribute("xmlns:rep" + i, vp.getProperty("RepSchemaURL") + i);
			
			Element importElement = repSchema.createElement(xmlSchemaName + "import");
			importElement.setAttribute("namespace", vp.getProperty("RepSchemaURL") + i);
			importElement.setAttribute("schemaLocation", temporalBundleDir + "rep" + i + ".xsd");
			schemaElement.appendChild(importElement);
		}
		
		Element schemaItemSequencecElement = addSchemaVaryingRoot();
		
		for (int i=0 ; i<schemaAnnotationNodes.getLength() ; i++){
			Element currElement = (Element)schemaAnnotationNodes.item(i);
			/* 
			 * At this point not clear whether these beginDate and endDate will appear in the repSchema.
			 * If they do, how can we show the actual times. 
			 */
			beginDate = currElement.getElementsByTagName("tTime").item(0).getChildNodes().item(0).getNodeValue();
			if (i+1 < schemaAnnotationNodes.getLength()){
				Element nextElement = (Element)schemaAnnotationNodes.item(i+1);
				endDate = nextElement.getElementsByTagName("tTime").item(0).getChildNodes().item(0).getNodeValue();
			}else{
				endDate = "9999-12-31";
			}
			ITimePeriod tp = new TimePeriod(beginDate, endDate);
			scpTimeSpanList.add(tp);

			snapshotSchema = temporalBundleDir + currElement.getAttribute("snapshotSchema");
			temporalAnnotation = temporalBundleDir + currElement.getAttribute("temporalAnnotation");
			physicalAnnotation = temporalBundleDir + currElement.getAttribute("physicalAnnotation");
			
			/* Create rep schema corresponding to the schema version and write it to the correspondingly numbered file */
			DoSchemaMapping doDataSchemaMapping = new DoSchemaMapping();
			Document repSchemaDoc = doDataSchemaMapping.createRepresentationalSchema(snapshotSchema, temporalAnnotation, physicalAnnotation, i);
			
			cp.writeDocument(repSchemaDoc, temporalBundleDir + "/rep" + i + ".xsd");

			schemaItemSequencecElement.appendChild(createSchemaVersionElement(i));
			
			/* Create the item identifier Correspondence hashMap and put that into itemIdCorrList */
			NodeList nlItemIdCorrList = currElement.getElementsByTagName("itemIdentifierCorrespondence");
			Hashtable itemIdMap = new Hashtable();
			for (int j=0 ; j<nlItemIdCorrList.getLength() ; j++){
				Element currCorr = (Element)nlItemIdCorrList.item(j);
				ItemIdentifierCorr itemIdCorr = new ItemIdentifierCorr(currCorr.getAttribute("oldRef"), currCorr.getAttribute("newRef"), currCorr.getAttribute("mappingType"));
				itemIdMap.put(currCorr.getAttribute("newRef"), itemIdCorr);
			}
			itemIdCorrList.add(itemIdMap);
		}
		return repSchema;
	}
	
	public ArrayList getItemIdentifierCorrList(){
		return itemIdCorrList;
	}
	
	public ArrayList getScpTimeSpanList(){
		return scpTimeSpanList;
	}
	
	private Element addSchemaVaryingRoot(){
		Element root = repSchema.getDocumentElement();
		Element svRoot = repSchema.createElement(xmlSchemaName + "element");
		svRoot.setAttribute("name","sv_root");
		root.appendChild(svRoot);
		
		Element complexTypeElement = repSchema.createElement(xmlSchemaName + "complexType");
		svRoot.appendChild(complexTypeElement);
		Element sequenceElement = repSchema.createElement(xmlSchemaName + "sequence");
		complexTypeElement.appendChild(sequenceElement);
	
		Element schemaItemElement = repSchema.createElement(xmlSchemaName + "element");
		schemaItemElement.setAttribute("name","schemaItem");
		sequenceElement.appendChild(schemaItemElement);

		Element complexTypeElement1 = repSchema.createElement(xmlSchemaName + "complexType");
		schemaItemElement.appendChild(complexTypeElement1);
		Element sequenceElement1 = repSchema.createElement(xmlSchemaName + "sequence");
		complexTypeElement1.appendChild(sequenceElement1);
		
		Element bundleAttribute = repSchema.createElement(xmlSchemaName + "attribute");
		bundleAttribute.setAttribute("name", "bundle");
		bundleAttribute.setAttribute("type", xmlSchemaName + "string");
		complexTypeElement.appendChild(bundleAttribute);
		return sequenceElement1;
	}
	
	private Element createSchemaElement(){
		repSchema = cp.createDocument(vp.getProperty("XMLSchemaURL"), xmlSchemaName + "schema", null);
        Element schemaElement = repSchema.getDocumentElement();
        schemaElement.setAttribute("xmlns",vp.getProperty("RepSchemaURL"));
        schemaElement.setAttribute("xmlns:tv",vp.getProperty("TVSchemaURL"));
		schemaElement.setAttribute("xmlns:xsi",vp.getProperty("XMLSchemaInstance"));
		schemaElement.setAttribute("elementFormDefault","unqualified");
		schemaElement.setAttribute("targetNamespace",vp.getProperty("RepSchemaURL"));
		
		Element tvImportElement = repSchema.createElement(xmlSchemaName + "import");
		tvImportElement.setAttribute("namespace", vp.getProperty("TVSchemaURL"));
		tvImportElement.setAttribute("schemaLocation", vp.getProperty("TVSchema"));
		schemaElement.appendChild(tvImportElement);
		
		return schemaElement;
	}

	private Element createSchemaVersionElement(int schemaIndex){
		
		Element schemaVersionElement = repSchema.createElement(xmlSchemaName + "element");
		schemaVersionElement.setAttribute("name","schemaVersion"+schemaIndex);
		schemaVersionElement.setAttribute("minOccurs","1"); 
		schemaVersionElement.setAttribute("maxOccurs","1");
		
		Element complexTypeElement = repSchema.createElement(xmlSchemaName + "complexType");
		Element sequenceElement = repSchema.createElement(xmlSchemaName + "sequence");

		Element tvElement = repSchema.createElement(xmlSchemaName + "element");
		tvElement.setAttribute("ref", tvSchemaName + "timestamp_TransExtent");
		tvElement.setAttribute("minOccurs","1"); 
		tvElement.setAttribute("maxOccurs","1"); 
		
		Element temporalRootElement = repSchema.createElement(xmlSchemaName + "element");
		temporalRootElement.setAttribute("ref","rep"+schemaIndex + ":temporalRoot");
		temporalRootElement.setAttribute("minOccurs","1"); 
		temporalRootElement.setAttribute("maxOccurs","1");

		schemaVersionElement.appendChild(complexTypeElement);
		complexTypeElement.appendChild(sequenceElement);
		
		sequenceElement.appendChild(tvElement);
		sequenceElement.appendChild(temporalRootElement);

		return schemaVersionElement;
	}
}
